/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server.tools.service;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.sample.server.tools.service.OrdenResponse;
import org.springframework.ai.mcp.sample.server.tools.service.TransporteTool;
import org.springframework.ai.mcp.sample.server.tools.service.TransporteToolServiceImpl;
import org.springframework.ai.mcp.sample.server.tools.service.Transportista;
import org.springframework.ai.mcp.sample.server.tools.service.TransportistaResponse;
import org.springframework.ai.mcp.sample.server.tools.service.Vehiculo;
import org.springframework.ai.mcp.sample.server.tools.service.newOrderRequest;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;

@Service
public class TransporteToolServiceImpl
implements TransporteTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransporteToolServiceImpl.class);
    private final WebClient.Builder webClientBuilder;
    private final Environment env;

    private String getFastApiBaseUrl() {
        return this.env.getProperty("api.lhia.transporte", "http://localhost:8002");
    }

    @Tool(description="Registra un nuevo transportista y su veh\u00edculo en la red. \u00dasese solo cuando el usuario solicita registrarse.")
    public TransportistaResponse registerNewTransporter(Transportista newTransporter, Vehiculo newVehiculo) {
        String url = this.getFastApiBaseUrl() + "/transportistas/register";
        log.info("\ud83d\udfe6 Registrando transportista en {}", (Object)url);
        try {
            TransportistaResponse response = (TransportistaResponse)((WebClient.RequestBodySpec)this.webClientBuilder.build().post().uri(url, new Object[0])).bodyValue((Object)new TransporterRegistrationBody(newTransporter, newVehiculo)).retrieve().bodyToMono(TransportistaResponse.class).timeout(Duration.ofSeconds(10L)).block();
            if (response != null) {
                log.info("\u2705 Transportista {} registrado correctamente con ID: {}", (Object)response.nombre(), (Object)response._id());
            } else {
                log.warn("\u26a0\ufe0f No se recibi\u00f3 respuesta del servidor FastAPI para registro de transportista.");
            }
            return response;
        }
        catch (WebClientResponseException e) {
            log.error("\u274c Error HTTP al registrar transportista: {} {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            throw new RuntimeException("Error HTTP al registrar transportista: " + e.getMessage(), e);
        }
        catch (Exception e) {
            log.error("\u274c Error general al registrar transportista en {}", (Object)url, (Object)e);
            throw new RuntimeException("Error al registrar transportista: " + e.getMessage(), e);
        }
    }

    @Tool(description="Crea una nueva orden de transporte. \u00dasese cada vez que un cliente solicita un servicio o cotizaci\u00f3n.")
    public OrdenResponse registerNewOrder(newOrderRequest orden) {
        String url = this.getFastApiBaseUrl() + "/ordenes/";
        try {
            ObjectMapper mapper = new ObjectMapper();
            String bodyJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)orden);
            log.info("\ud83d\udce6 Enviando POST a {} con body:\n{}", (Object)url, (Object)bodyJson);
        }
        catch (Exception e) {
            log.warn("Error al serializar orden para log: {}", (Object)e.getMessage());
        }
        try {
            OrdenResponse response = (OrdenResponse)((WebClient.RequestBodySpec)this.webClientBuilder.build().post().uri(url, new Object[0])).bodyValue((Object)orden).retrieve().bodyToMono(OrdenResponse.class).timeout(Duration.ofSeconds(10L)).block();
            if (response == null) {
                throw new RuntimeException("No se recibi\u00f3 respuesta del servidor FastAPI al crear orden.");
            }
            log.info("\u2705 Orden {} creada exitosamente en FastAPI.", (Object)response._id());
            String notifResult = this.sendOrderNotification(response);
            log.info("\ud83d\udce8 Resultado de notificaci\u00f3n: {}", (Object)notifResult);
            return response;
        }
        catch (WebClientResponseException e) {
            log.error("\u274c Error HTTP al crear orden: {} {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            throw new RuntimeException("Error HTTP al crear orden: " + e.getMessage(), e);
        }
        catch (Exception e) {
            log.error("\u274c Error general al crear orden en {}", (Object)url, (Object)e);
            throw new RuntimeException("Error al crear orden: " + e.getMessage(), e);
        }
    }

    public List<TransportistaResponse> getTransportistas() {
        String url = this.getFastApiBaseUrl() + "/transportistas/";
        log.info("\ud83d\udce1 Solicitando lista de transportistas desde {}", (Object)url);
        try {
            ResponseEntity responseEntity = (ResponseEntity)this.webClientBuilder.build().get().uri(url, new Object[0]).retrieve().toEntity(String.class).timeout(Duration.ofSeconds(10L)).block();
            log.info("Status code: {}", (Object)responseEntity.getStatusCode());
            String rawJson = (String)responseEntity.getBody();
            log.info("\ud83d\udce5 Respuesta cruda de transportistas: {}", (Object)rawJson);
            if (rawJson == null || rawJson.isBlank()) {
                log.warn("\u26a0\ufe0f No se recibi\u00f3 contenido del servidor FastAPI.");
                return List.of();
            }
            ObjectMapper mapper = new ObjectMapper();
            Object jsonObj = mapper.readValue(rawJson, Object.class);
            String prettyJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObj);
            log.info("\ud83d\udcc4 Transportistas (formato JSON bonito):\n{}", (Object)prettyJson);
            List transportistas = (List)mapper.readValue(rawJson, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, TransportistaResponse.class));
            log.info("\u2705 Recibidos {} transportistas despu\u00e9s del mapeo.", (Object)transportistas.size());
            return transportistas;
        }
        catch (Exception e) {
            log.error("\u274c Error al obtener transportistas desde {}", (Object)url, (Object)e);
            return List.of();
        }
    }

    public String sendOrderNotification(OrdenResponse orden) {
        String token = this.env.getProperty("api.whatsapp.bearer.token");
        String apiUrl = this.env.getProperty("api.whatsapp.url");
        List transportistas = this.getTransportistas();
        if (transportistas.isEmpty()) {
            return "Advertencia: No se encontraron transportistas disponibles.";
        }
        int enviados = 0;
        ObjectMapper mapper = new ObjectMapper();
        for (TransportistaResponse t : transportistas) {
            try {
                Map body = this.buildWhatsappInteractiveBody(orden, t.telefono_whatsapp());
                String bodyPretty = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)body);
                log.info("\ud83d\udce6 Enviando WhatsApp a {} con endpoint: {}\n{}", new Object[]{t.telefono_whatsapp(), apiUrl, bodyPretty});
                ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClientBuilder.build().post().uri(apiUrl, new Object[0])).header("Authorization", new String[]{"Bearer " + token})).bodyValue((Object)body).retrieve().bodyToMono(String.class).timeout(Duration.ofSeconds(8L)).block();
                ++enviados;
                log.debug("\u2705 Notificaci\u00f3n enviada a {}", (Object)t.telefono_whatsapp());
            }
            catch (WebClientResponseException e) {
                log.error("\u274c Error HTTP al enviar WhatsApp a {}: {}", (Object)t.telefono_whatsapp(), (Object)e.getStatusCode());
            }
            catch (Exception e) {
                log.error("\u274c Error desconocido al enviar WhatsApp a {}.", (Object)t.telefono_whatsapp(), (Object)e);
            }
        }
        String resultado = String.format("Notificaci\u00f3n enviada a %d de %d transportistas.", enviados, transportistas.size());
        log.info("\ud83d\udce8 {}", (Object)resultado);
        return resultado;
    }

    private Map<String, Object> buildWhatsappInteractiveBody(OrdenResponse orden, String whatsapp) {
        String footerText = String.format("%s (%s)", orden.fecha(), orden.hora());
        return Map.of("messaging_product", "whatsapp", "to", whatsapp, "type", "interactive", "interactive", Map.of("type", "button", "header", Map.of("type", "text", "text", "\u26a0\ufe0f NUEVA ORDEN CREADA"), "body", Map.of("text", String.format("CARGA: %s (%.2f Ton)\nSITIO DE CARGA: %s\nDESTINO: %s\n\nCLIENTE: %s\nORDEN ID: %s", orden.carga(), orden.peso_aproximado(), orden.origen(), orden.destino(), orden.nombreCliente(), orden._id())), "footer", Map.of("text", footerText), "action", Map.of("buttons", List.of(Map.of("type", "reply", "reply", Map.of("id", orden.whatsappCliente() + "_" + orden.nombreCliente(), "title", "\ud83e\udd1d TOMAR ORDEN"))))));
    }

    @Generated
    public TransporteToolServiceImpl(WebClient.Builder webClientBuilder, Environment env) {
        this.webClientBuilder = webClientBuilder;
        this.env = env;
    }
}

