/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server.tools.service;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.ai.mcp.sample.server.tools.service.AvailabilityRequest;
import org.springframework.ai.mcp.sample.server.tools.service.AvailabilityResponse;
import org.springframework.ai.mcp.sample.server.tools.service.CancelReservationRequest;
import org.springframework.ai.mcp.sample.server.tools.service.CancelReservationResponse;
import org.springframework.ai.mcp.sample.server.tools.service.ClubAvailability;
import org.springframework.ai.mcp.sample.server.tools.service.Court;
import org.springframework.ai.mcp.sample.server.tools.service.DailyAvailabilityRequest;
import org.springframework.ai.mcp.sample.server.tools.service.DailyAvailabilityResponse;
import org.springframework.ai.mcp.sample.server.tools.service.PadelTool;
import org.springframework.ai.mcp.sample.server.tools.service.ReservationDetails;
import org.springframework.ai.mcp.sample.server.tools.service.ReservationRequest;
import org.springframework.ai.mcp.sample.server.tools.service.ReservationResponse;
import org.springframework.ai.mcp.sample.server.tools.service.ViewReservationsRequest;
import org.springframework.ai.mcp.sample.server.tools.service.ViewReservationsResponse;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.stereotype.Service;

@Service
public class PadelToolServiceImpl
implements PadelTool {
    private static final Map<Integer, String> CLUBES = Map.of(1, "Break Point Padel", 2, "PADELEATE", 3, "Pro Padel Cuenca");

    @Tool(description="Encuentra todos los horarios disponibles para una fecha en todos los clubes.")
    public DailyAvailabilityResponse findAvailableSlots(DailyAvailabilityRequest request) {
        System.out.println("LOGICA MCP: Buscando slots para la fecha: " + request.date());
        List availabilityList = CLUBES.entrySet().stream().map(entry -> {
            List mockTimes = this.generateMockAvailableTimes(((Integer)entry.getKey()).intValue());
            return new ClubAvailability(((Integer)entry.getKey()).intValue(), (String)entry.getValue(), mockTimes);
        }).collect(Collectors.toList());
        return new DailyAvailabilityResponse(availabilityList);
    }

    @Tool(description="Verifica la disponibilidad para una hora y club espec\u00edficos.")
    public AvailabilityResponse checkAvailability(AvailabilityRequest request) {
        System.out.println("LOGICA MCP: Verificando disponibilidad para: " + String.valueOf(request));
        List<Court> availableCourts = List.of(new Court(1, "Cancha Central"), new Court(2, "Cancha Tws2"));
        return new AvailabilityResponse(availableCourts);
    }

    @Tool(description="Crea una nueva reserva")
    public ReservationResponse createReservation(ReservationRequest request) {
        System.out.println("LOGICA MCP: Creando reserva para: " + request.userInfo().name());
        String reservationId = "PAD-" + UUID.randomUUID().toString().substring(0, 8).toUpperCase();
        return new ReservationResponse(reservationId, "CONFIRMED", "\u00a1Reserva confirmada! Tu c\u00f3digo es " + reservationId + ". Te hemos enviado los detalles por correo.");
    }

    @Tool(description="Consulta las reservas de un usuario")
    public ViewReservationsResponse viewReservations(ViewReservationsRequest request) {
        System.out.println("LOGICA MCP: Buscando reservas para: " + request.userIdentifier());
        List<ReservationDetails> userReservations = List.of(new ReservationDetails("PAD-XYZ123", "Break Point Padel", "Cancha Tws2", "2025-10-15", "19:00"));
        return new ViewReservationsResponse(userReservations);
    }

    @Tool(description="Cancela una reserva existente")
    public CancelReservationResponse cancelReservation(CancelReservationRequest request) {
        System.out.println("LOGICA MCP: Cancelando reserva: " + request.reservationId());
        return new CancelReservationResponse("CANCELLED", "Tu reserva " + request.reservationId() + " ha sido cancelada.");
    }

    private List<String> generateMockAvailableTimes(int clubId) {
        return switch (clubId) {
            case 1 -> List.of("09:00", "11:00", "18:00");
            case 3 -> List.of("10:00", "15:00", "19:00", "20:00");
            default -> List.of();
        };
    }
}

