/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.sample.server;

import org.springframework.ai.mcp.sample.server.McpServerApplication;
import org.springframework.ai.mcp.sample.server.tools.service.TransporteTool;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.function.FunctionToolCallback;
import org.springframework.ai.tool.method.MethodToolCallbackProvider;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class McpServerApplication {
    public static void main(String[] args) {
        SpringApplication.run(McpServerApplication.class, (String[])args);
    }

    @Bean
    public ToolCallbackProvider transporteToolService(TransporteTool transporteToolService) {
        return MethodToolCallbackProvider.builder().toolObjects(new Object[]{transporteToolService}).build();
    }

    @Bean
    public ToolCallback toUpperCase() {
        return FunctionToolCallback.builder((String)"toUpperCase", input -> input.input().toUpperCase()).inputType(TextInput.class).description("Put the text to upper case").build();
    }
}

