/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.tws2.Documents.HistoryConversationItem;
import com.whatsapp.tws2.Repository.Services.CampaignMessageDAO;
import com.whatsapp.tws2.client.botpress.service.ApiBotpressService;
import com.whatsapp.tws2.client.lhiaflow.service.ApiLhiaFLowService;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.ExtractData;
import com.whatsapp.tws2.data.LhiaFlowRequest;
import com.whatsapp.tws2.data.TextMessageRequest;
import com.whatsapp.tws2.data.UserResponse;
import com.whatsapp.tws2.service.ApiCreditFormService;
import com.whatsapp.tws2.service.CampaignService;
import com.whatsapp.tws2.service.HistoryConversationItemService;
import com.whatsapp.tws2.service.LhiaProcessService;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.service.ThinkAgentService;
import com.whatsapp.tws2.service.WebhookService;
import com.whatsapp.tws2.utils.MessageTypeUtils;
import com.whatsapp.tws2.utils.ResponseUtil;
import com.whatsapp.tws2.utils.StatusUtil;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class WebhookServiceImpl
implements WebhookService {
    private static final Logger log = LoggerFactory.getLogger(WebhookServiceImpl.class);
    private final StateConversationService stateConversationService;
    private final Environment env;
    private final ApiBotpressService apiBotpressService;
    private final ObjectMapper objectMapper;
    private final ResponseUtil responseUtil;
    private final LhiaProcessService lhiaProcessService;
    private final CampaignMessageDAO campaignMessageDAO;
    private final ApiWhatsAppService whatsAppService;
    private final ThinkAgentService thinkAgentService;
    private final CampaignService campaignService;
    private final ApiCreditFormService apiCreditFormService;
    private final ApiLhiaFLowService apiLhiaFLowService;
    private final HistoryConversationItemService historyConversationService;

    public Mono<ResponseEntity<?>> handleWebhook(Object userResponse) {
        String defaultCallback = this.env.getProperty("tsa.canal.callback.default");
        this.triggerExtractedFlowInBackground(userResponse);
        Mono convertedRequestBody = this.convertToUserResponse(userResponse);
        return convertedRequestBody.flatMap(metaEvent -> {
            this.campaignService.notifyMessageStatuses(metaEvent).subscribe();
            log.info("continua el flujo del evento recibido");
            return this.convertToUserResponse(userResponse).flatMap(userBody -> this.stateConversationService.validateAndUpdateChatFromUserResponse(userBody).flatMap(status -> {
                log.info("status conversation> " + status);
                return this.responseUtil.getMessage(userBody).flatMap(data -> {
                    log.info("WEBHOOK DATA {}", data);
                    HistoryConversationItem historyConversationItem = new HistoryConversationItem(data.getIdConversation(), data.getCanal(), data.getMessage(), data.getMessageId(), StatusUtil.ROL_USER, status, data.getNick());
                    return this.historyConversationService.save(historyConversationItem).then(this.handleStatusSwitch(status, data, userBody, userResponse));
                }).onErrorResume(e -> {
                    log.error("Error handling message data: ", e);
                    return Mono.just((Object)ResponseEntity.status((int)500).body((Object)"Internal Server Error"));
                });
            })).onErrorResume(e -> {
                log.error("Error handling webhook: ", e);
                return Mono.just((Object)ResponseEntity.status((int)500).body((Object)"Internal Server Error"));
            });
        });
    }

    private void triggerExtractedFlowInBackground(Object userResponse) {
        try {
            Map payload = (Map)userResponse;
            String flowToken = this.extractFlowToken(payload);
            if (flowToken == null) {
                log.warn("FlowToken no encontrado en payload");
                return;
            }
            log.info("Flow token recibido (bg): {}", (Object)flowToken);
            this.apiCreditFormService.generateLink(flowToken, payload).doOnNext(resp -> log.info("Respuesta API generateLink (bg): {}", resp)).doOnError(e -> log.error("Error en generateLink (bg)", e)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        }
        catch (Exception e2) {
            log.error("Error triggerExtractedFlowInBackground", (Throwable)e2);
        }
    }

    private Mono<ResponseEntity<?>> handleStatusSwitch(String status, ExtractData data, UserResponse userResponse, Object originalBody) {
        switch (status) {
            case "NORMAL": {
                return this.handleNormalCase(data, originalBody);
            }
            case "ASESOR": 
            case "THINKAGENT": {
                return this.handleThinkAgentCase(data);
            }
            case "CAMPANA": {
                return this.handleCampaignCase(data);
            }
            case "LHIA": 
            case "LHIA_OFERTAS": 
            case "LHIA_BARATAZOS": {
                return this.handleLhiaCase(userResponse, status);
            }
        }
        return Mono.just((Object)ResponseEntity.ok((Object)"Unhandled case"));
    }

    private Mono<ResponseEntity<?>> handleLhiaCase(UserResponse userResponse, String status) {
        return this.responseUtil.getMessage(userResponse).flatMap(body -> {
            log.info("WEBHOOK DATA TO LHIA {} WITH STATUS {}", body, (Object)status);
            if (body.getType().equals(MessageTypeUtils.TYPE_TEXT) || body.getType().equals(MessageTypeUtils.TYPE_INTERACTIVE)) {
                return this.lhiaProcessService.sendMessageLhiaSwitch(body, status).map(res -> ResponseEntity.ok().build());
            }
            return this.whatsAppService.sendTextMessage(new TextMessageRequest(body.getIdConversation(), StatusUtil.MSG_NOTIFICACION_CLIENTE_ARCHIVOS_ASESOR)).map(res -> ResponseEntity.ok().build());
        });
    }

    private Mono<ResponseEntity<?>> handleNormalCase(ExtractData data, Object originalBody) {
        String message;
        if (data != null && data.getMessage() != null && ((message = data.getMessage().replaceAll(" ", "").toUpperCase()).equals(StatusUtil.ST_FINALIZAR) || message.contains("EL CHAT FUE CERRADO"))) {
            data.setButtonId(StatusUtil.ST_FINALIZAR);
            return this.lhiaProcessService.sendMessageLhiaSwitch(data, StatusUtil.ST_NORMAL).map(res -> ResponseEntity.ok().build());
        }
        return this.apiBotpressService.notifyWebHook(originalBody).map(res -> ResponseEntity.ok().build());
    }

    public Mono<ResponseEntity<String>> sendMessagetoAsesorFromApi(LhiaFlowRequest body) {
        body.setCallbackId(this.env.getProperty("canal.callback.ventas"));
        return this.apiLhiaFLowService.sendMesssageToAsesor(body).defaultIfEmpty((Object)"").flatMap(data -> this.saveHistoryConversations(body, data)).flatMap(result -> {
            TextMessageRequest textMessagaReq = new TextMessageRequest(body.getConversationChatId(), StatusUtil.MSG_SOLICITUD_ASESOR);
            return this.whatsAppService.sendTextMessage(textMessagaReq).flatMap(res -> {
                log.info("Mensaje enviado a WhatsApp: {}", res);
                return Mono.just((Object)ResponseEntity.ok().body((Object)""));
            });
        }).doOnError(error -> log.error("Error occurred during message sending", error)).onErrorResume(error -> Mono.just((Object)ResponseEntity.status((int)500).build()));
    }

    private Mono<String> saveHistoryConversations(LhiaFlowRequest messageModel, String data) {
        HistoryConversationItem userHistoryConversation = new HistoryConversationItem(messageModel.getConversationChatId(), messageModel.getChannel(), (String)(messageModel.getMessage() != null ? messageModel.getMessage() : "Archivo de tipo [" + messageModel.getType() + "]"), "INDEFINIDO", "USER", "ASESOR", messageModel.getNick());
        return this.historyConversationService.save(userHistoryConversation).thenReturn((Object)data);
    }

    private String extractFlowToken(Map<String, Object> payload) {
        try {
            Map responseJson;
            List entryList = this.safeCastToList(payload.get("entry"));
            if (entryList == null || entryList.isEmpty()) {
                return null;
            }
            Map entry = (Map)entryList.get(0);
            List changesList = this.safeCastToList(entry.get("changes"));
            if (changesList == null || changesList.isEmpty()) {
                return null;
            }
            Map change = (Map)changesList.get(0);
            Map value = this.safeCastToMap(change.get("value"));
            if (value == null) {
                return null;
            }
            List messagesList = this.safeCastToList(value.get("messages"));
            if (messagesList == null || messagesList.isEmpty()) {
                return null;
            }
            Map message = (Map)messagesList.get(0);
            Map interactive = this.safeCastToMap(message.get("interactive"));
            if (interactive == null) {
                return null;
            }
            Map nfmReply = this.safeCastToMap(interactive.get("nfm_reply"));
            if (nfmReply == null) {
                return null;
            }
            Object responseJsonObj = nfmReply.get("response_json");
            if (responseJsonObj == null) {
                return null;
            }
            if (responseJsonObj instanceof String) {
                String jsonStr = (String)responseJsonObj;
                responseJson = (Map)this.objectMapper.readValue(jsonStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                responseJson = this.safeCastToMap(responseJsonObj);
            }
            return responseJson != null ? this.safeCastToString(responseJson.get("flow_token")) : null;
        }
        catch (Exception e) {
            log.error("Error extrayendo flow_token", (Throwable)e);
            return null;
        }
    }

    private List<Map<String, Object>> safeCastToList(Object obj) {
        if (obj instanceof List) {
            List list = (List)obj;
            for (Object item : list) {
                if (item instanceof Map) continue;
                return null;
            }
            return list;
        }
        return null;
    }

    private Map<String, Object> safeCastToMap(Object obj) {
        return obj instanceof Map ? (Map)obj : null;
    }

    private String safeCastToString(Object obj) {
        String str;
        return obj instanceof String ? (str = (String)obj) : null;
    }

    private Mono<UserResponse> convertToUserResponse(Object userResponse) {
        try {
            String json = this.objectMapper.writeValueAsString(userResponse);
            UserResponse userBody = (UserResponse)this.objectMapper.readValue(json, UserResponse.class);
            return Mono.just((Object)userBody);
        }
        catch (Exception e) {
            log.error("Error converting user response: ", (Throwable)e);
            return Mono.error((Throwable)new RuntimeException("Invalid user response format"));
        }
    }

    private Mono<ResponseEntity<?>> handleThinkAgentCase(ExtractData data) {
        return this.thinkAgentService.sendMessageToTAS(data).map(res -> {
            log.info("THINKAGENT RESPONSE: {}", res);
            return ResponseEntity.ok().build();
        });
    }

    private Mono<ResponseEntity<?>> handleCampaignCase(ExtractData data) {
        log.info("CAMPA\u00d1A, data {}", (Object)data);
        return this.campaignMessageDAO.findLastMessageTemplateByConversationId(data.getIdConversation()).flatMap(campaignMessage -> {
            if (!campaignMessage.isBlank()) {
                String messageOriginal;
                Object newMessageModified = "";
                String string = messageOriginal = data.getMessage() == null ? "" : data.getMessage();
                if (!data.getType().equals(MessageTypeUtils.TYPE_TEXT)) {
                    ExtractData textMessageModel = new ExtractData(data);
                    newMessageModified = "*Msg usuario:* [Archivo adjunto en el siguiente mensaje]\n*Campa\u00f1a:* " + campaignMessage;
                    textMessageModel.setMessage((String)newMessageModified);
                    textMessageModel.setType(MessageTypeUtils.TYPE_TEXT);
                    log.warn("EL MENSAJE DE CAMPANA CON ARCHIVOS ES: {}", (Object)data.getMessage());
                    return this.stateConversationService.updateStateByConversationId(data.getIdConversation(), StatusUtil.ST_THINKAGENT).then(this.handleThinkAgentCase(textMessageModel).delayElement(Duration.ofSeconds(3L)).flatMap(res -> this.handleThinkAgentCase(data)));
                }
                newMessageModified = "*Msg usuario:* " + messageOriginal + "\n*Campa\u00f1a:* " + campaignMessage;
                data.setMessage((String)newMessageModified);
                log.warn("EL MENSAJE DE CAMPANA ES: {}", (Object)data.getMessage());
            }
            return this.stateConversationService.updateStateByConversationId(data.getIdConversation(), StatusUtil.ST_THINKAGENT).then(this.handleThinkAgentCase(data));
        });
    }

    public WebhookServiceImpl(StateConversationService stateConversationService, Environment env, ApiBotpressService apiBotpressService, ObjectMapper objectMapper, ResponseUtil responseUtil, LhiaProcessService lhiaProcessService, CampaignMessageDAO campaignMessageDAO, ApiWhatsAppService whatsAppService, ThinkAgentService thinkAgentService, CampaignService campaignService, ApiCreditFormService apiCreditFormService, ApiLhiaFLowService apiLhiaFLowService, HistoryConversationItemService historyConversationService) {
        this.stateConversationService = stateConversationService;
        this.env = env;
        this.apiBotpressService = apiBotpressService;
        this.objectMapper = objectMapper;
        this.responseUtil = responseUtil;
        this.lhiaProcessService = lhiaProcessService;
        this.campaignMessageDAO = campaignMessageDAO;
        this.whatsAppService = whatsAppService;
        this.thinkAgentService = thinkAgentService;
        this.campaignService = campaignService;
        this.apiCreditFormService = apiCreditFormService;
        this.apiLhiaFLowService = apiLhiaFLowService;
        this.historyConversationService = historyConversationService;
    }
}

