/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.Documents.HistoryConversationItem;
import com.whatsapp.tws2.Repository.Services.ConversationDAO;
import com.whatsapp.tws2.client.tsa.TsaApiService;
import com.whatsapp.tws2.client.tsa.models.Attachment;
import com.whatsapp.tws2.client.tsa.models.CallbackTsaMessage;
import com.whatsapp.tws2.client.tsa.models.ResponseMessageEvent;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.ExtractData;
import com.whatsapp.tws2.data.FileMessageRequestFromHiper;
import com.whatsapp.tws2.data.TextMessageRequest;
import com.whatsapp.tws2.data.tsa.RequestMessageModel;
import com.whatsapp.tws2.service.HistoryConversationItemService;
import com.whatsapp.tws2.service.StartConversationEvents;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.service.ThinkAgentService;
import com.whatsapp.tws2.tsa.utils.TemplateTsaMessages;
import com.whatsapp.tws2.utils.MessageTypeUtils;
import com.whatsapp.tws2.utils.StatusUtil;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ThinkAgentServiceImpl
implements ThinkAgentService {
    private static final Logger log = LoggerFactory.getLogger(ThinkAgentServiceImpl.class);
    private final TsaApiService tsaApiService;
    private final StateConversationService stateConversationService;
    private final ApiWhatsAppService whatsAppService;
    private final HistoryConversationItemService historyConversationItemService;
    private final ConversationDAO conversationDAO;
    private final StartConversationEvents startConversationEvents;
    private final Environment env;

    public Mono<ResponseEntity<String>> sendMessageToWhatsappFromTSA(RequestMessageModel requestMessageModel) {
        HistoryConversationItem historyConversationItem = HistoryConversationItem.saveConversationFromTsa((String)requestMessageModel.getId(), (String)requestMessageModel.getPayload().getContent(), (String)requestMessageModel.getNick(), (String)requestMessageModel.getPayload().getType());
        return this.processMessageToTsa(requestMessageModel).flatMap(response -> {
            log.info("response webhook {}", response);
            historyConversationItem.setMessageMetaId((String)response.getBody());
            Mono updateState = Mono.empty();
            if (requestMessageModel.getPayload().getType().equalsIgnoreCase("text")) {
                String content = requestMessageModel.getPayload().getContent().toUpperCase();
                if (!content.contains("CONVERSACION_CERRADA") && !content.contains("POR FAVOR CALIFICA ESTA CONVERSACI")) {
                    updateState = this.stateConversationService.updateStateByConversationId(requestMessageModel.getId(), StatusUtil.ST_THINKAGENT);
                }
            } else {
                updateState = this.stateConversationService.updateStateByConversationId(requestMessageModel.getId(), StatusUtil.ST_THINKAGENT);
            }
            return Mono.just((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent")).then(updateState).then(this.historyConversationItemService.save(historyConversationItem)).thenReturn(response);
        });
    }

    private Mono<ResponseEntity<String>> processMessageToTsa(RequestMessageModel requestMessageModel) {
        switch (requestMessageModel.getPayload().getType()) {
            case "text": {
                TextMessageRequest textMessage = new TextMessageRequest(requestMessageModel.getId(), requestMessageModel.getPayload().getContent());
                if (textMessage.getMessage().toUpperCase().contains("CONVERSACION_CERRADA")) {
                    return Mono.delay((Duration)Duration.ofMillis(2000L)).then(this.stateConversationService.getStatusCoonversation(requestMessageModel.getId())).flatMap(state -> {
                        log.info("Estado de la conversacion a cerrar: {}", state);
                        if (state.equalsIgnoreCase(StatusUtil.ST_ASESOR) || state.equalsIgnoreCase(StatusUtil.ST_NORMAL)) {
                            log.info("MENSAJE DE CIERRE IGNORADO POR ESTADO: {}", state);
                            return Mono.just((Object)ResponseEntity.ok((Object)"CONVERSACION_CERRADA"));
                        }
                        String customMessage = this.env.getProperty("tsa.message.close.conversation", "");
                        Mono sendAction = Mono.empty();
                        if (!customMessage.isEmpty()) {
                            customMessage = customMessage.replace("\\n", "\n");
                            textMessage.setMessage(customMessage);
                            sendAction = this.whatsAppService.sendTextMessage(textMessage);
                        }
                        return sendAction.then(this.stateConversationService.updateStateByConversationId(textMessage.getPhoneNumber(), StatusUtil.ST_NORMAL).then(Mono.just((Object)ResponseEntity.ok((Object)"CONVERSACION_CERRADA"))));
                    });
                }
                if (textMessage.getMessage().toUpperCase().contains("POR FAVOR CALIFICA ESTA CONVERSACI")) {
                    return this.stateConversationService.getStatusCoonversation(requestMessageModel.getId()).flatMap(state -> {
                        log.info("Estado de la conversacion a cerrar: {}", state);
                        if (state.equalsIgnoreCase(StatusUtil.ST_ASESOR)) {
                            log.info("MENSAJE IGNORADO POR CAMBIO DE ASESOR");
                            return Mono.empty();
                        }
                        String customMessage = this.env.getProperty("tsa.message.close.conversation", "");
                        if (!customMessage.isEmpty()) {
                            customMessage = customMessage.replace("\\n", "\n");
                            textMessage.setMessage(customMessage + "\n\n" + textMessage.getMessage());
                        }
                        return this.whatsAppService.sendTextMessage(textMessage).flatMap(messageMetaId -> {
                            log.info("Meta message id: {}", messageMetaId);
                            return this.stateConversationService.updateStateByConversationId(textMessage.getPhoneNumber(), StatusUtil.ST_NORMAL).map(response -> messageMetaId);
                        });
                    });
                }
                if (textMessage.getMessage().toUpperCase().contains("ESTE MENSAJE SE HA ELIMINADO")) {
                    log.info("Mensaje de eliminaci\u00f3n ignorado");
                    return Mono.just((Object)ResponseEntity.ok((Object)UUID.randomUUID().toString()));
                }
                return this.whatsAppService.sendTextMessage(textMessage);
            }
            case "image": {
                FileMessageRequestFromHiper imageFileRequest = new FileMessageRequestFromHiper(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                return this.whatsAppService.sendImageMessage(imageFileRequest);
            }
            case "video": {
                FileMessageRequestFromHiper videoFileRequest = new FileMessageRequestFromHiper(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                return this.whatsAppService.sendVideoMessage(videoFileRequest);
            }
            case "document": {
                FileMessageRequestFromHiper documentFileRequest = new FileMessageRequestFromHiper(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                return this.whatsAppService.sendDocumentMessage(documentFileRequest);
            }
            case "audio": {
                FileMessageRequestFromHiper audioFileRequest = new FileMessageRequestFromHiper(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                return this.whatsAppService.sendAudioMessage(audioFileRequest);
            }
        }
        TextMessageRequest unknowTextMessage = new TextMessageRequest(requestMessageModel.getId(), requestMessageModel.getPayload().getContent());
        return this.whatsAppService.sendTextMessage(unknowTextMessage);
    }

    public Mono<ResponseEntity<String>> sendMessageToTAS(ExtractData dataMessageMeta) {
        log.info("Data message meta: {}", (Object)dataMessageMeta);
        String defaultCallback = this.env.getProperty("tsa.canal.callback.default");
        RequestMessageModel requestMessageModel = new RequestMessageModel();
        RequestMessageModel.Payload payload = new RequestMessageModel.Payload();
        if (dataMessageMeta.getType().equalsIgnoreCase(MessageTypeUtils.TYPE_LOCATION)) {
            payload.setType(MessageTypeUtils.TYPE_TEXT);
            payload.setContent(TemplateTsaMessages.TEMPLATE_MD_LOCATION.replace("{lat}", dataMessageMeta.getLatitude()).replace("{lon}", dataMessageMeta.getLongitude()));
        } else if (dataMessageMeta.getType().equals(MessageTypeUtils.TYPE_TEXT)) {
            payload.setType(dataMessageMeta.getType());
            payload.setContent(dataMessageMeta.getMessage());
        } else {
            if (dataMessageMeta.getFile() == null) {
                log.warn("TIPO DE DATO NO IDENTIFICADO O SOPORTADO, PROCEDE A IGNORAR");
                return Mono.just((Object)ResponseEntity.ok((Object)"mensaje aceptado"));
            }
            payload.setType(MessageTypeUtils.TYPE_FILE);
            payload.setContent(dataMessageMeta.getFile());
        }
        requestMessageModel.setType("message");
        requestMessageModel.setId(dataMessageMeta.getIdConversation());
        requestMessageModel.setPayload(payload);
        requestMessageModel.setChannel("whatsapp");
        requestMessageModel.setNick(dataMessageMeta.getNick());
        if (dataMessageMeta.getReplyMessageId() != null) {
            return this.historyConversationItemService.getMessageByMetaId(dataMessageMeta.getReplyMessageId()).flatMap(message -> {
                log.info("The message replied is: {}", message);
                requestMessageModel.getPayload().setRepliedMessage(message);
                return this.conversationDAO.getCallbackByConversationId(dataMessageMeta.getIdConversation()).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> this.sendMessageToTAS(requestMessageModel, callbackId).flatMap(response -> this.saveSentMessageToTASFromWebhook(dataMessageMeta, (ResponseMessageEvent)response.getBody()).thenReturn((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent"))));
            });
        }
        return this.conversationDAO.getCallbackByConversationId(dataMessageMeta.getIdConversation()).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> this.sendMessageToTAS(requestMessageModel, callbackId).flatMap(response -> this.saveSentMessageToTASFromWebhook(dataMessageMeta, (ResponseMessageEvent)response.getBody()).thenReturn((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent"))));
    }

    private Mono<Void> saveSentMessageToTASFromWebhook(ExtractData dataMessage, ResponseMessageEvent responseTsaEvent) {
        if (responseTsaEvent != null && responseTsaEvent.getEventType() != null) {
            log.info("Response event type: {}", (Object)responseTsaEvent.getEventType());
            String eventType = responseTsaEvent.getEventType();
            if (eventType.equalsIgnoreCase("message_new_delivered") && !dataMessage.getType().equals(MessageTypeUtils.TYPE_TEXT)) {
                List attachments;
                CallbackTsaMessage objectCast = responseTsaEvent.getCallbackTsaMessage();
                log.error("EL OBJETO ES DE TIPO {}", (Object)objectCast);
                if (objectCast != null && (attachments = objectCast.getAttachments()) != null && !attachments.isEmpty()) {
                    Attachment attachment = (Attachment)attachments.get(0);
                    return this.saveSentMessageToTAS(dataMessage.getIdConversation(), dataMessage.getCanal(), attachment.getDataUrl(), dataMessage.getMessageId(), dataMessage.getNick(), attachment.getFileType());
                }
            }
        }
        return this.saveSentMessageToTAS(dataMessage.getIdConversation(), dataMessage.getCanal(), dataMessage.getMessage(), dataMessage.getMessageId(), dataMessage.getNick(), MessageTypeUtils.TYPE_TEXT);
    }

    public Mono<Void> saveSentMessageToTAS(String idConversation, String canal, String content, String messageId, String nick, String messageType) {
        HistoryConversationItem historyConversationItem = HistoryConversationItem.saveNewMessageToTsa((String)idConversation, (String)content, (String)messageId, (String)nick, (String)messageType);
        return this.historyConversationItemService.save(historyConversationItem);
    }

    private Mono<ResponseEntity<ResponseMessageEvent>> sendMessageToTAS(RequestMessageModel requestMessageModel, String callbackId) {
        return this.tsaApiService.sendMesssageToAsesor(requestMessageModel, callbackId).flatMap(response -> {
            log.info("response webhook {}", response);
            return Mono.just((Object)ResponseEntity.ok((Object)response));
        });
    }

    public Mono<ResponseEntity<String>> redirectLhiaConversationToTSA(RequestMessageModel requestMessageModel) {
        String status = StatusUtil.ST_THINKAGENT;
        String callbackId = this.env.getProperty("tsa.canal.callback.channel1");
        requestMessageModel.setChannel("whatsapp");
        return this.sendMessageToTAS(requestMessageModel, callbackId).flatMap(response -> {
            log.info("response webhook {}", response);
            return this.stateConversationService.updateStateByConversationId(requestMessageModel.getId(), status).then(this.startConversationEvents.startConversation(requestMessageModel.getId(), requestMessageModel.getNick())).then(Mono.just((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent")));
        });
    }

    public ThinkAgentServiceImpl(TsaApiService tsaApiService, StateConversationService stateConversationService, ApiWhatsAppService whatsAppService, HistoryConversationItemService historyConversationItemService, ConversationDAO conversationDAO, StartConversationEvents startConversationEvents, Environment env) {
        this.tsaApiService = tsaApiService;
        this.stateConversationService = stateConversationService;
        this.whatsAppService = whatsAppService;
        this.historyConversationItemService = historyConversationItemService;
        this.conversationDAO = conversationDAO;
        this.startConversationEvents = startConversationEvents;
        this.env = env;
    }
}

