/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.tws2.Documents.CampaignModel;
import com.whatsapp.tws2.Documents.HistoryConversationItem;
import com.whatsapp.tws2.Documents.ImagenModel;
import com.whatsapp.tws2.Repository.ImagenMessageRepository;
import com.whatsapp.tws2.Repository.Services.CampaignMessageDAO;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.ConversationSummaryResponse;
import com.whatsapp.tws2.data.campaigns.whatsapp.ComponentWhatsapp;
import com.whatsapp.tws2.data.campaigns.whatsapp.TemplateWhatsApp;
import com.whatsapp.tws2.data.campaigns.whatsapp.WhatsAppCampaignModel;
import com.whatsapp.tws2.data.templatesMeta.TemplateData;
import com.whatsapp.tws2.data.templatesMeta.WhatsAppTemplate;
import com.whatsapp.tws2.data.templatesMeta.WhatsAppTemplateRequest;
import com.whatsapp.tws2.exceptions.TemplateNotFoundException;
import com.whatsapp.tws2.service.HistoryConversationItemService;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.service.TemplateService;
import com.whatsapp.tws2.utils.StatusUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    private final ApiWhatsAppService whatsAppService;
    private final StateConversationService stateConversationService;
    private final HistoryConversationItemService historyConversationService;
    private final Environment env;
    private final CampaignMessageDAO campaignMessageDAO;
    private final ObjectMapper objectMapper;
    private final ImagenMessageRepository imagenRepository;
    private static final Map<String, String> CHANNEL_TITLES = new HashMap();

    public Mono<List<WhatsAppTemplate>> getTemplates() {
        log.info("FILTER ALL TEMPLATES");
        return this.whatsAppService.getTemplates().flatMap(data -> {
            try {
                ArrayList<WhatsAppTemplate> templates = new ArrayList<WhatsAppTemplate>();
                if (data == null || data.getData() == null) {
                    return Mono.just(templates);
                }
                for (TemplateData.Template templateNode : data.getData()) {
                    WhatsAppTemplate template = new WhatsAppTemplate();
                    template.setName(templateNode.getName());
                    template.setLanguage(templateNode.getLanguage());
                    template.setStatus(templateNode.getStatus());
                    template.setCategory(templateNode.getCategory());
                    template.setId(templateNode.getId());
                    ArrayList<WhatsAppTemplate.Component> components = new ArrayList<WhatsAppTemplate.Component>();
                    for (TemplateData.Component componentNode : templateNode.getComponents()) {
                        WhatsAppTemplate.Component component = new WhatsAppTemplate.Component();
                        component.setType(componentNode.getType());
                        component.setText(componentNode.getText());
                        component.setFormat(componentNode.getFormat());
                        components.add(component);
                    }
                    template.setComponents(components);
                    templates.add(template);
                }
                return Mono.just(templates);
            }
            catch (Exception e) {
                log.error("Error parsing templates", (Throwable)e);
                return Mono.error((Throwable)new RuntimeException("Error parsing templates"));
            }
        });
    }

    public Mono<WhatsAppTemplate> getTemplateById(String id) {
        Mono monoTemplate = this.getTemplates().flatMapMany(Flux::fromIterable).filter(template -> template.getId().equals(id)).next().switchIfEmpty(Mono.error((Throwable)new TemplateNotFoundException(id)));
        return monoTemplate.flatMap(tem -> this.obtenerIdImagen(tem.getId()).switchIfEmpty(Mono.just((Object)"S/N")).flatMap(imgUrl -> {
            if (imgUrl.equals("S/N")) {
                return Mono.just((Object)tem);
            }
            tem.setFileUrl(imgUrl);
            return Mono.just((Object)tem);
        }));
    }

    private String validatePhoneNumber(String phoneNumber) {
        if (((String)(phoneNumber = ((String)phoneNumber).replace(" ", ""))).startsWith("+")) {
            phoneNumber = ((String)phoneNumber).replace("+", "");
        }
        if (((String)phoneNumber).startsWith("0")) {
            phoneNumber = "593" + ((String)phoneNumber).substring(1);
        }
        return phoneNumber;
    }

    public Mono<Void> sendMessageFromTemplate(WhatsAppTemplateRequest request) {
        try {
            ArrayList<ComponentWhatsapp> components = new ArrayList<ComponentWhatsapp>();
            ComponentWhatsapp headerCompoent = request.generarHeaderComponent(request.getHeader());
            if (headerCompoent != null) {
                components.add(headerCompoent);
            }
            ComponentWhatsapp bodyComponent = request.generarBodyComponent(request.getBody());
            log.info("Body component: {}", (Object)bodyComponent);
            if (bodyComponent != null) {
                components.add(bodyComponent);
            }
            TemplateWhatsApp template = new TemplateWhatsApp(request.getTemplateName(), components, request.getLanguage());
            String phoneNumber = this.validatePhoneNumber(request.getNumber());
            WhatsAppCampaignModel campaign = new WhatsAppCampaignModel(phoneNumber, template);
            String campaignJson = this.objectMapper.writeValueAsString((Object)campaign);
            log.info("Sending template message to numbers, {}", (Object)campaignJson);
            log.info("Sending template message to numbers");
            String canal_asesor = this.getCanal(request.getCanal());
            HistoryConversationItem userHistoryConversation = new HistoryConversationItem(phoneNumber, "whatsapp", request.getTemplate(), StatusUtil.ST_ASESOR, "CAMPANA", "User");
            return this.whatsAppService.sendMessageTemplateToWhatsAppAPI((Object)campaign).flatMap(response -> {
                log.info("Response from WhatsApp API: {}", response);
                return this.stateConversationService.validateAndUpdateChatFromMetaTemplate(phoneNumber, canal_asesor, request.getTemplate(), request.getCategoria()).then(this.historyConversationService.save(userHistoryConversation)).doOnError(e -> log.error("ERROR AL CAMBIAR EL ESTADO", e));
            }).doOnError(e -> {
                log.error("Error sending message to " + phoneNumber + ": " + e.getMessage());
                if (e instanceof WebClientResponseException) {
                    WebClientResponseException webClientResponseException = (WebClientResponseException)e;
                    String errorBody = webClientResponseException.getResponseBodyAsString();
                    log.error("Error body from WhatsApp API: {}", (Object)errorBody);
                }
                CampaignModel camp = new CampaignModel();
                camp.setConversationId(phoneNumber);
                camp.setMessageTemplate(request.getTemplate());
                camp.setCategoria(request.getCategoria());
                camp.setCanal(canal_asesor);
                camp.setSend(Boolean.valueOf(false));
                this.campaignMessageDAO.save(camp).subscribe();
            });
        }
        catch (Exception e2) {
            return Mono.error((Throwable)e2);
        }
    }

    private String getCanal(String codigoCanal) {
        String canalDefecto = this.env.getProperty("tsa.canal.callback.default");
        String channel1 = this.env.getProperty("canal.callback.channel1");
        String channel2 = this.env.getProperty("canal.callback.channel2");
        String channel3 = this.env.getProperty("tsa.canal.callback.channel3");
        String channel4 = this.env.getProperty("canal.callback.channel4");
        switch (codigoCanal) {
            case "1": {
                return channel1;
            }
            case "2": {
                return channel2;
            }
            case "3": {
                return channel3;
            }
            case "4": {
                return channel4;
            }
        }
        return canalDefecto;
    }

    public Mono<ConversationSummaryResponse> getConversationSummary(Date fecha_inicio, Date fecha_fin) {
        return this.whatsAppService.getConversationSummary(fecha_inicio, fecha_fin);
    }

    public Mono<List<CampaignModel>> getAllConversationIncident() {
        return this.campaignMessageDAO.getAllConversationIncident().map(campaignList -> {
            campaignList.forEach(campaign -> {
                String title = (String)CHANNEL_TITLES.get(campaign.getCanal());
                if (title != null) {
                    campaign.setCanal(title);
                }
            });
            return campaignList;
        });
    }

    public Mono<ImagenModel> guardarUrlImagen(String id, String url) {
        ImagenModel imagen = new ImagenModel(id, url);
        return this.imagenRepository.save((Object)imagen);
    }

    public Mono<String> obtenerIdImagen(String id) {
        return this.imagenRepository.findByIdImagen(id).map(ImagenModel::getUrlImagen);
    }

    public TemplateServiceImpl(ApiWhatsAppService whatsAppService, StateConversationService stateConversationService, HistoryConversationItemService historyConversationService, Environment env, CampaignMessageDAO campaignMessageDAO, ObjectMapper objectMapper, ImagenMessageRepository imagenRepository) {
        this.whatsAppService = whatsAppService;
        this.stateConversationService = stateConversationService;
        this.historyConversationService = historyConversationService;
        this.env = env;
        this.campaignMessageDAO = campaignMessageDAO;
        this.objectMapper = objectMapper;
        this.imagenRepository = imagenRepository;
    }

    static {
        CHANNEL_TITLES.put("45fe8e1646aa61-e0901b1abd129c-68dc0ee3ddd74d", "ATENCI\u00d3N CLIENTE");
        CHANNEL_TITLES.put("6bf1a1f91cd9b8-b7720508e294b9-0d07ec71d2be65", "COBRANZAS");
        CHANNEL_TITLES.put("4f6e419d3a8b25-6dbdcf5ab9486b-62ec01ee0ab6bc", "VENTAS");
        CHANNEL_TITLES.put("62e80355d4463f-bf7e415142af71-5e24020cef4625", "SERVICIO T\u00c9CNICO");
    }
}

