/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.data.state.UpdateStateConversationRequest;
import com.whatsapp.tws2.service.StartConversationEvents;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.service.StateValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class StateValidationServiceImpl
implements StateValidationService {
    private static final Logger log = LoggerFactory.getLogger(StateValidationServiceImpl.class);
    private final StartConversationEvents startConversationEvents;
    private final StateConversationService stateConversationService;

    public Mono<Void> validateState(UpdateStateConversationRequest body) {
        String event;
        log.info("Validating state for conversation");
        String conversationId = body.getConversationId();
        String nick = body.getNick();
        switch (event = body.getEvent().toUpperCase().trim().replace(" ", "")) {
            case "ASESOR": {
                return this.startConversationEvents.startConversation(conversationId, nick).then(this.stateConversationService.updateStateConversation(body));
            }
            case "THINKAGENT": {
                return this.startConversationEvents.startConversation(conversationId, nick).then(this.stateConversationService.updateStateConversation(body));
            }
        }
        return this.stateConversationService.updateStateConversation(body);
    }

    public StateValidationServiceImpl(StartConversationEvents startConversationEvents, StateConversationService stateConversationService) {
        this.startConversationEvents = startConversationEvents;
        this.stateConversationService = stateConversationService;
    }
}

