/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.Documents.HistoryConversationItem;
import com.whatsapp.tws2.client.lhia.service.ApiLhiaService;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.ExtractData;
import com.whatsapp.tws2.data.RequestQuestionLhia;
import com.whatsapp.tws2.data.ResponseLhia;
import com.whatsapp.tws2.data.ResponseLhiaEvent;
import com.whatsapp.tws2.data.TextMessageRequest;
import com.whatsapp.tws2.data.tsa.RequestMessageModel;
import com.whatsapp.tws2.service.ButtonBuilderMetaService;
import com.whatsapp.tws2.service.HistoryConversationItemService;
import com.whatsapp.tws2.service.LhiaProcessService;
import com.whatsapp.tws2.service.ThinkAgentService;
import com.whatsapp.tws2.utils.EventLhiaEnum;
import com.whatsapp.tws2.utils.MessageTypeUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class LhiaProcessServiceImpl
implements LhiaProcessService {
    private static final Logger log = LoggerFactory.getLogger(LhiaProcessServiceImpl.class);
    private final ApiLhiaService apiLhiaService;
    private final ApiWhatsAppService whatsAppService;
    private final ButtonBuilderMetaService builderMetaService;
    private final HistoryConversationItemService historyConversationService;
    private final ThinkAgentService thinkAgentService;
    private final Environment env;

    private RequestQuestionLhia buildRequestQuestionLhia(ExtractData data, String estadoLhia) {
        String descripcion = this.env.getProperty("lhia.api.role");
        String usuario = this.env.getProperty("lhia.api.user");
        RequestQuestionLhia requestToLhia = new RequestQuestionLhia();
        String LHIA_TIPO = this.env.getProperty("lhia.tipo.".concat(estadoLhia).toLowerCase());
        String btnTitle = data.getButtonTitle() == null ? "" : data.getButtonTitle();
        String buttonId = EventLhiaEnum.ME_INTERESA.getTitle().equals(btnTitle) ? null : data.getButtonId();
        String messageToLhia = btnTitle.equals(EventLhiaEnum.ME_INTERESA.getTitle()) ? data.getButtonId() : data.getMessage();
        requestToLhia.setQuestion(messageToLhia);
        requestToLhia.setDescripcion(descripcion);
        requestToLhia.setUsuario(usuario);
        requestToLhia.setIdPlatform(data.getIdConversation());
        requestToLhia.setPlatform(data.getCanal());
        requestToLhia.setActivity(buttonId);
        requestToLhia.setTipo(LHIA_TIPO);
        return requestToLhia;
    }

    public Mono<Void> sendMessageLhiaSwitch(ExtractData data, String estadoLhia) {
        RequestQuestionLhia requestToLhia = this.buildRequestQuestionLhia(data, estadoLhia);
        log.info("request lhia event {}", (Object)requestToLhia);
        if (requestToLhia.getActivity() == null) {
            return this.sendMessageToLHIA(requestToLhia, data, estadoLhia).then();
        }
        return this.sendMessageToLHIAEvents(requestToLhia).then();
    }

    private Mono<ResponseLhiaEvent> sendMessageToLHIAEvents(RequestQuestionLhia requestToLhia) {
        log.info("LOADING EVENT TO LHIA WITH INFO: {}", (Object)requestToLhia);
        return this.apiLhiaService.getToken().flatMap(tokenModel -> this.apiLhiaService.sendEventToLhia(requestToLhia, tokenModel.getAccessToken()).flatMap(responseLhia -> {
            if (responseLhia.getSuccess().booleanValue() && responseLhia.getPayload() != null) {
                String lhiaEventMessage = responseLhia.getPayload().getMessage();
                TextMessageRequest templateInitMessage = new TextMessageRequest();
                templateInitMessage.setPhoneNumber(requestToLhia.getIdPlatform());
                templateInitMessage.setMessage(lhiaEventMessage);
                if (responseLhia.getPayload().getHasEvent().booleanValue()) {
                    List events = responseLhia.getPayload().getEvents();
                    String eventTitle = responseLhia.getPayload().getTitleEvent();
                    Map jsonMap = this.builderMetaService.generateListButtonFromEvent(events, requestToLhia.getIdPlatform(), eventTitle);
                    if (jsonMap != null) {
                        return this.whatsAppService.sendTextMessage(templateInitMessage).flatMap(ignore -> this.whatsAppService.sendTextMessageWithButton(jsonMap)).then(this.apiLhiaService.getSignOut(tokenModel.getRefreshToken()).thenReturn(responseLhia));
                    }
                }
                return this.whatsAppService.sendTextMessage(templateInitMessage).then(this.apiLhiaService.getSignOut(tokenModel.getRefreshToken()).thenReturn(responseLhia));
            }
            String lhiaEventMessage = responseLhia.getPayload().getMessage();
            return this.whatsAppService.sendTextMessage(new TextMessageRequest(requestToLhia.getIdPlatform(), lhiaEventMessage)).flatMap(ignore -> Mono.empty()).flatMap(ignore -> this.apiLhiaService.getSignOut(tokenModel.getRefreshToken()).thenReturn(responseLhia)).onErrorResume(e -> this.handleError(e, "Error in sendMessageToLHIA"));
        })).onErrorResume(e -> this.handleError(e, "Error in sendMessageToLHIA"));
    }

    private Mono<ResponseLhia> sendMessageToLHIA(RequestQuestionLhia requestToLhia, ExtractData data, String estadoLhia) {
        return this.apiLhiaService.getToken().flatMap(tokenModel -> this.apiLhiaService.sendMesssageToLhia(requestToLhia, tokenModel.getAccessToken()).flatMap(response -> this.saveHistoryConversations(requestToLhia, response, data)).flatMap(responseLhia -> {
            if (responseLhia.getResponse() != null && responseLhia.getResponse().equalsIgnoreCase(EventLhiaEnum.REDIRECT_ASESOR.getKey())) {
                log.info("redirecting to asesor");
                RequestMessageModel requestMessageModel = new RequestMessageModel(data.getIdConversation(), MessageTypeUtils.TYPE_MESSAGE, data.getNick(), MessageTypeUtils.TYPE_TEXT, "Hola, este usuario fue dirigido a ti por Marci y ahora requiere asistencia personalizada.", null);
                return this.thinkAgentService.redirectLhiaConversationToTSA(requestMessageModel).thenReturn(responseLhia);
            }
            if (responseLhia.getListProductVectorial() != null && !responseLhia.getListProductVectorial().isEmpty()) {
                TextMessageRequest templateInitMessage = new TextMessageRequest();
                templateInitMessage.setPhoneNumber(data.getIdConversation());
                templateInitMessage.setMessage("Disponemos de:");
                return Mono.when((Iterable)responseLhia.getListProductVectorial().stream().map(productVectorial -> {
                    Map jsonMap = this.builderMetaService.generateButtonFromEventProduct(productVectorial, responseLhia.getResponse(), data.getIdConversation());
                    Map jsonListProducts = this.builderMetaService.generateButtonFromProductWithCaptionAndButton(productVectorial, data.getIdConversation());
                    if (jsonListProducts != null && responseLhia.getListProductVectorial().size() > 1) {
                        return this.whatsAppService.sendTextMessageWithButton(jsonListProducts);
                    }
                    if (jsonMap != null && responseLhia.getListProductVectorial().size() == 1) {
                        return this.whatsAppService.sendTextMessageWithButton(jsonMap);
                    }
                    return Mono.empty();
                }).collect(Collectors.toList())).then(this.apiLhiaService.getSignOut(tokenModel.getRefreshToken()).thenReturn(responseLhia));
            }
            Map jsonMap = this.builderMetaService.generateButtonFromEvent(responseLhia.getResponse(), data.getIdConversation());
            return this.whatsAppService.sendTextMessage(new TextMessageRequest(data.getIdConversation(), responseLhia.getResponse())).flatMap(ignore -> {
                System.err.println("\n\n" + jsonMap + "\n\n");
                if (jsonMap != null) {
                    return this.whatsAppService.sendTextMessageWithButton(jsonMap);
                }
                return Mono.empty();
            }).flatMap(ignore -> this.apiLhiaService.getSignOut(tokenModel.getRefreshToken()).thenReturn(responseLhia)).onErrorResume(e -> this.handleError(e, "Error in sendMessageToLHIA"));
        })).onErrorResume(e -> this.handleError(e, "Error in sendMessageToLHIA"));
    }

    private Mono<ResponseLhia> saveHistoryConversations(RequestQuestionLhia requestToLhia, ResponseLhia response, ExtractData data) {
        String messageResponseLhia = this.getMessageResponseLhia(response);
        HistoryConversationItem userHistoryConversationItem = new HistoryConversationItem(requestToLhia.getIdPlatform(), requestToLhia.getPlatform(), requestToLhia.getQuestion(), "USER", "LHIA", data.getNick());
        HistoryConversationItem lhiaHistoryConversationItem = new HistoryConversationItem(requestToLhia.getIdPlatform(), requestToLhia.getPlatform(), messageResponseLhia, "LHIA", "LHIA", data.getNick());
        return this.historyConversationService.save(lhiaHistoryConversationItem).then(this.historyConversationService.save(userHistoryConversationItem)).thenReturn((Object)response);
    }

    private String getMessageResponseLhia(ResponseLhia response) {
        if ("ADD_PRODUCT".equalsIgnoreCase(response.getResponse())) {
            return "Producto Encontrado";
        }
        return Optional.ofNullable(response.getListProductVectorial()).filter(list -> !list.isEmpty()).map(list -> "Disponemos de:\n" + list.stream().map(p -> p.getTitulo() + "\nPrecio: " + p.getPrecio() + "\n").collect(Collectors.joining())).orElse(response.getResponse());
    }

    private <T> Mono<T> handleError(Throwable e, String errorMessage) {
        log.error(errorMessage, e);
        return Mono.error((Throwable)new RuntimeException(errorMessage, e));
    }

    public LhiaProcessServiceImpl(ApiLhiaService apiLhiaService, ApiWhatsAppService whatsAppService, ButtonBuilderMetaService builderMetaService, HistoryConversationItemService historyConversationService, ThinkAgentService thinkAgentService, Environment env) {
        this.apiLhiaService = apiLhiaService;
        this.whatsAppService = whatsAppService;
        this.builderMetaService = builderMetaService;
        this.historyConversationService = historyConversationService;
        this.thinkAgentService = thinkAgentService;
        this.env = env;
    }
}

