/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.DTO.DailyCountDTO;
import com.whatsapp.tws2.Repository.Services.CampaignMessageDAO;
import com.whatsapp.tws2.client.campanas.service.ApiCampanasService;
import com.whatsapp.tws2.data.UserResponse;
import com.whatsapp.tws2.service.CampaignService;
import com.whatsapp.tws2.utils.Utils;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class CampaignServiceImpl
implements CampaignService {
    private static final Logger log = LoggerFactory.getLogger(CampaignServiceImpl.class);
    private final CampaignMessageDAO campaignMessageDAO;
    private final ApiCampanasService apiCampanasService;

    public Mono<List<DailyCountDTO>> obtenerListaDeCompanasPorFecha(LocalDate inicio, LocalDate fin) {
        return this.campaignMessageDAO.obtenerReporteDiario(inicio, fin).collectList().map(lista -> Utils.completarDiasFaltantes((List)lista, (LocalDate)inicio, (LocalDate)fin));
    }

    public Mono<Void> notifyMessageStatuses(UserResponse metaEvent) {
        try {
            List listEntries = metaEvent.getEntry();
            boolean shouldNotify = false;
            for (UserResponse.Entry entry : listEntries) {
                List changes = entry.getChanges();
                for (UserResponse.Change change : changes) {
                    UserResponse.Value value = change.getValue();
                    if (value == null || value.getStatuses() == null || value.getStatuses().isEmpty()) continue;
                    shouldNotify = true;
                    break;
                }
                if (!shouldNotify) continue;
                break;
            }
            if (shouldNotify) {
                return this.apiCampanasService.notifyStatusesMessages((Object)metaEvent);
            }
            return Mono.empty();
        }
        catch (Exception e) {
            log.error("Error procesando evento de meta", (Throwable)e);
            return Mono.error((Throwable)e);
        }
    }

    public CampaignServiceImpl(CampaignMessageDAO campaignMessageDAO, ApiCampanasService apiCampanasService) {
        this.campaignMessageDAO = campaignMessageDAO;
        this.apiCampanasService = apiCampanasService;
    }
}

