/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.controller;

import com.whatsapp.tws2.DTO.DailyCountDTO;
import com.whatsapp.tws2.Documents.CampaignModel;
import com.whatsapp.tws2.Documents.ImagenModel;
import com.whatsapp.tws2.data.ConversationSummaryResponse;
import com.whatsapp.tws2.data.DateConversation;
import com.whatsapp.tws2.data.templatesMeta.WhatsAppTemplate;
import com.whatsapp.tws2.data.templatesMeta.WhatsAppTemplateRequest;
import com.whatsapp.tws2.service.CampaignService;
import com.whatsapp.tws2.service.TemplateService;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api"})
public class WhatsappController {
    private static final Logger log = LoggerFactory.getLogger(WhatsappController.class);
    private final TemplateService templateService;
    private final CampaignService campaignService;

    @GetMapping(value={"/templates"})
    public Mono<List<WhatsAppTemplate>> getTemplates() throws Exception {
        return this.templateService.getTemplates();
    }

    @GetMapping(value={"/templates/{id}"})
    public Mono<WhatsAppTemplate> getTemplateById(@PathVariable(value="id", required=true) String id) {
        return this.templateService.getTemplateById(id);
    }

    @PostMapping(value={"/send-template"})
    public Mono<Void> sendTemplate(@RequestBody WhatsAppTemplateRequest request) {
        return this.templateService.sendMessageFromTemplate(request);
    }

    @PostMapping(value={"/analytics-conversation"}, produces={"application/json"})
    public Mono<ConversationSummaryResponse> getConversationSummary(@RequestBody DateConversation dateConversation) {
        return this.templateService.getConversationSummary(dateConversation.getFecha_inicio(), dateConversation.getFecha_fin());
    }

    @GetMapping(value={"/conversations-incidents"})
    public Mono<List<CampaignModel>> getAllConversationIncident() {
        return this.templateService.getAllConversationIncident();
    }

    @PostMapping(value={"/imagen-url"})
    public Mono<ImagenModel> guardarImagen(@RequestBody ImagenModel body) {
        return this.templateService.guardarUrlImagen(body.getIdImagen(), body.getUrlImagen());
    }

    @GetMapping(value={"/imagen-url/{id}"})
    public Mono<String> obtenerImagen(@PathVariable String id) {
        return this.templateService.obtenerIdImagen(id);
    }

    @PostMapping(value={"/campaigns-count"})
    public Mono<List<DailyCountDTO>> getAllCampaigns(@RequestBody Map<String, String> body) {
        LocalDate initDate = LocalDate.parse(body.get("initDate"));
        LocalDate endDate = LocalDate.parse(body.get("endDate"));
        return this.campaignService.obtenerListaDeCompanasPorFecha(initDate, endDate);
    }

    public WhatsappController(TemplateService templateService, CampaignService campaignService) {
        this.templateService = templateService;
        this.campaignService = campaignService;
    }
}

