/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.controller;

import com.whatsapp.tws2.client.botpress.service.ApiBotpressService;
import com.whatsapp.tws2.data.LhiaFlowRequest;
import com.whatsapp.tws2.service.WebhookService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/webhook"})
public class WebhookController {
    private static final Logger log = LoggerFactory.getLogger(WebhookController.class);
    private final Environment env;
    private final ApiBotpressService apiBotpressService;
    private final WebhookService webhookService;

    @GetMapping(value={""})
    public Mono<ResponseEntity<String>> verifyWebhook(@RequestParam(name="hub.verify_token", required=false) String verifyToken, @RequestParam(name="hub.challenge", required=false) String challenge) {
        log.info("Verificando webhook con token: {} y challenge: {}", (Object)verifyToken, (Object)challenge);
        String VERIFY_TOKEN = this.env.getProperty("whatsapp.verify.token");
        if (VERIFY_TOKEN.equals(verifyToken)) {
            return Mono.just((Object)new ResponseEntity((Object)challenge, (HttpStatusCode)HttpStatus.OK));
        }
        log.error("Error de verificaci\u00f3n: token no coincide");
        return Mono.just((Object)new ResponseEntity((Object)"Error de verificaci\u00f3n", (HttpStatusCode)HttpStatus.FORBIDDEN));
    }

    @PostMapping(value={""})
    public Mono<ResponseEntity<?>> handleWebhook(@RequestBody Object userResponse) {
        return this.webhookService.handleWebhook(userResponse);
    }

    @PostMapping(value={"sendMessageToAsesorFromApiStatus"})
    public Mono<ResponseEntity<String>> sendMessagetoAsesorFromApi(@RequestBody LhiaFlowRequest body) {
        return this.webhookService.sendMessagetoAsesorFromApi(body);
    }

    public Environment getEnv() {
        return this.env;
    }

    public ApiBotpressService getApiBotpressService() {
        return this.apiBotpressService;
    }

    public WebhookService getWebhookService() {
        return this.webhookService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebhookController)) {
            return false;
        }
        WebhookController other = (WebhookController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        ApiBotpressService this$apiBotpressService = this.getApiBotpressService();
        ApiBotpressService other$apiBotpressService = other.getApiBotpressService();
        if (this$apiBotpressService == null ? other$apiBotpressService != null : !this$apiBotpressService.equals(other$apiBotpressService)) {
            return false;
        }
        WebhookService this$webhookService = this.getWebhookService();
        WebhookService other$webhookService = other.getWebhookService();
        return !(this$webhookService == null ? other$webhookService != null : !this$webhookService.equals(other$webhookService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebhookController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        ApiBotpressService $apiBotpressService = this.getApiBotpressService();
        result = result * 59 + ($apiBotpressService == null ? 43 : $apiBotpressService.hashCode());
        WebhookService $webhookService = this.getWebhookService();
        result = result * 59 + ($webhookService == null ? 43 : $webhookService.hashCode());
        return result;
    }

    public String toString() {
        return "WebhookController(env=" + this.getEnv() + ", apiBotpressService=" + this.getApiBotpressService() + ", webhookService=" + this.getWebhookService() + ")";
    }

    public WebhookController(Environment env, ApiBotpressService apiBotpressService, WebhookService webhookService) {
        this.env = env;
        this.apiBotpressService = apiBotpressService;
        this.webhookService = webhookService;
    }
}

