/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.client.campanas;

import com.whatsapp.tws2.client.campanas.models.CampanasApiConfiguration;
import com.whatsapp.tws2.client.campanas.service.ApiCampanasService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class ApiCampanas
implements ApiCampanasService {
    private static final Logger log = LoggerFactory.getLogger(ApiCampanas.class);
    private final CampanasApiConfiguration campanasApiConfiguration;
    private final WebClient webClient;
    private final Environment env;

    public ApiCampanas(CampanasApiConfiguration campanasApiConfiguration, @Qualifier(value="loadBalancedWebClientBuilder") WebClient.Builder webClientBuilder, Environment env) {
        String gateway_url = env.getProperty("gateway.url");
        this.webClient = webClientBuilder.baseUrl(gateway_url).build();
        this.campanasApiConfiguration = campanasApiConfiguration;
        this.env = env;
    }

    public Mono<Void> notifyStatusesMessages(Object payload) {
        log.info("Notificando actualizacion de estado");
        String WHATSAPP_API_URL = this.campanasApiConfiguration.getNotificacion();
        log.warn(payload.toString());
        return ((WebClient.RequestBodySpec)this.webClient.post().uri(WHATSAPP_API_URL, new Object[0])).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)payload)).retrieve().bodyToMono(Void.class).doOnNext(response -> log.info("Message status notified: {}", response)).onErrorResume(err -> {
            log.error("ERROR NOTIFING {}", (Object)err.getMessage());
            return Mono.empty();
        });
    }
}

