/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.Repository;

import com.whatsapp.tws2.DTO.DailyCountDTO;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Date;
import org.bson.Document;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Repository;
import reactor.core.publisher.Flux;

@Repository
public class CampaignReactiveReportRepository {
    private final ReactiveMongoTemplate reactiveMongoTemplate;

    public Flux<DailyCountDTO> getDailyCounts(LocalDate start, LocalDate end) {
        Date startDate = Date.from(start.atStartOfDay().toInstant(ZoneOffset.UTC));
        Date endDate = Date.from(end.atTime(23, 59, 59).toInstant(ZoneOffset.UTC));
        MatchOperation match = Aggregation.match((Criteria)Criteria.where((String)"createdAt").gte((Object)startDate).lte((Object)endDate));
        ProjectionOperation project = Aggregation.project((String[])new String[0]).andExpression("dateToString('%Y-%m-%d', createdAt)", new Object[0]).as("date");
        GroupOperation group = Aggregation.group((String[])new String[]{"date"}).count().as("total");
        SortOperation sort = Aggregation.sort((Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, project, group, sort});
        return this.reactiveMongoTemplate.aggregate(aggregation, "campaign_model", Document.class).map(doc -> new DailyCountDTO(doc.getString((Object)"_id"), (long)doc.getInteger((Object)"total").intValue()));
    }

    public CampaignReactiveReportRepository(ReactiveMongoTemplate reactiveMongoTemplate) {
        this.reactiveMongoTemplate = reactiveMongoTemplate;
    }
}

