/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.utils;

import com.whatsapp.campaign.data.CampaignDataRequest;
import com.whatsapp.campaign.data.WhatsAppTemplateRequest;
import com.whatsapp.campaign.utils.TemplateCloneUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TemplateBatchBuilder {
    public static List<WhatsAppTemplateRequest> buildFromCampaignRequest(CampaignDataRequest request) {
        return request.getListCamping().stream().map(itemData -> {
            WhatsAppTemplateRequest copy = TemplateCloneUtil.deepCopyTemplate((WhatsAppTemplateRequest)request.getTemplate());
            List values = itemData.getParams() != null ? itemData.getParams() : List.of();
            List names = itemData.getParamsName();
            List parameters = IntStream.range(0, values.size()).mapToObj(i -> {
                String value = (String)values.get(i);
                String name = names != null && names.size() > i ? (String)names.get(i) : null;
                return new WhatsAppTemplateRequest.BodyParameter("text", name, value);
            }).collect(Collectors.toList());
            if (copy.getBody() != null) {
                copy.getBody().setParameters(parameters);
            }
            if (copy.getButtons() != null && !copy.getButtons().isEmpty() && itemData.getPath() != null) {
                for (WhatsAppTemplateRequest.Button button : copy.getButtons()) {
                    if (!"URL".equalsIgnoreCase(button.getType()) && !"url".equalsIgnoreCase(button.getSub_type())) continue;
                    WhatsAppTemplateRequest.ButtonParameter buttonParam = new WhatsAppTemplateRequest.ButtonParameter("text", itemData.getPath());
                    ArrayList<WhatsAppTemplateRequest.ButtonParameter> buttonParams = new ArrayList<WhatsAppTemplateRequest.ButtonParameter>();
                    buttonParams.add(buttonParam);
                    button.setParameters(buttonParams);
                }
            }
            copy.setNumber(itemData.getNumber());
            return copy;
        }).toList();
    }
}

