/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.utils;

import java.util.Map;
import org.springframework.core.env.Environment;

public class CanalMapper {
    private static final Map<String, String> CHANNEL_TITLES = Map.of("TWS-88574e75-cc46-4c8f-8a42-1068913a7e50", "CHANNEL-1", "TWS-4a74d6ce-2f50-4e04-bd39-db85069d2726", "CHANNEL-2");

    public static String getTitle(String canalCode) {
        return CHANNEL_TITLES.getOrDefault(canalCode, canalCode);
    }

    public static String getCanal(String codeCanal, Environment env) {
        String defaultCanal = env.getProperty("tsa.canal.callback.default", "CANAL_DESCONOCIDO");
        return switch (codeCanal) {
            case "1" -> env.getProperty("tsa.canal.callback.channel1", defaultCanal);
            case "2" -> env.getProperty("tsa.canal.callback.channel2", defaultCanal);
            default -> defaultCanal;
        };
    }
}

