/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.sender;

import com.whatsapp.campaign.cache.MessageStateCacheService;
import com.whatsapp.campaign.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.campaign.data.TemplateWhatsApp;
import com.whatsapp.campaign.data.WhatsAppCampaignModel;
import com.whatsapp.campaign.data.WhatsAppTemplateRequest;
import com.whatsapp.campaign.documents.CampaignModel;
import com.whatsapp.campaign.documents.CampaignModelHeader;
import com.whatsapp.campaign.documents.HistoryConversationItem;
import com.whatsapp.campaign.repository.service.CampaignMessageDAO;
import com.whatsapp.campaign.repository.service.CampaignModelHeaderDAO;
import com.whatsapp.campaign.service.HistoryConversationItemService;
import com.whatsapp.campaign.service.StateConversationService;
import com.whatsapp.campaign.utils.CampaignModelUtil;
import com.whatsapp.campaign.utils.CanalMapper;
import com.whatsapp.campaign.utils.ErrorParserUtil;
import com.whatsapp.campaign.utils.PhoneNumberUtil;
import com.whatsapp.campaign.utils.StatusUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TemplateMessageSenderService {
    private static final Logger log = LoggerFactory.getLogger(TemplateMessageSenderService.class);
    private final ApiWhatsAppService whatsAppService;
    private final MessageStateCacheService messageStateCacheService;
    private final CampaignModelHeaderDAO campaignModelHeaderDAO;
    private final StateConversationService stateConversationService;
    private final HistoryConversationItemService historyConversationService;
    private final CampaignMessageDAO campaignMessageDAO;
    private final Environment env;

    public Mono<String> sendMessageFromTemplateListItem(List<WhatsAppTemplateRequest> listRequest, String userName) {
        if (listRequest == null || listRequest.isEmpty()) {
            log.warn("La lista de plantillas est\u00e1 vac\u00eda, no se enviar\u00e1 ning\u00fan mensaje.");
            return Mono.empty();
        }
        return this.saveCampaignHeader(listRequest, userName).flatMap(header -> this.sendMessages(listRequest, userName, header.getId()).thenReturn((Object)header.getId()));
    }

    private Mono<Void> sendMessages(List<WhatsAppTemplateRequest> listRequest, String userName, String campaignId) {
        log.info("Iniciando env\u00edo de {} mensajes para la campa\u00f1a {} por el usuario {}", new Object[]{listRequest.size(), campaignId, userName});
        return Flux.fromIterable(listRequest).buffer(20).concatMap(batch -> Flux.fromIterable((Iterable)batch).flatMap(request -> {
            log.info("request: {}", request);
            return this.sendMessageTemplateCartItem(request, userName, campaignId).flatMap(response -> {
                String messageId = response.getMessageId();
                String status = response.getMessageStatus() != null ? response.getMessageStatus() : "UNKNOWN";
                log.info("Mensaje enviado exitosamente a {}. messageId: {}, status: {}", new Object[]{request.getNumber(), messageId, status});
                log.debug("Guardando estado del mensaje en cache. messageId: {}, status: {}", (Object)messageId, (Object)status);
                return this.messageStateCacheService.setState(messageId, status).thenReturn(response);
            }).onErrorResume(error -> {
                log.error("Error al enviar mensaje a {}: {}", new Object[]{request.getNumber(), error.getMessage(), error});
                return Mono.empty();
            });
        })).doOnError(error -> log.error("Error inesperado durante el env\u00edo masivo de mensajes: {}", (Object)error.getMessage(), error)).doOnTerminate(() -> log.info("Finaliz\u00f3 el env\u00edo de mensajes para la campa\u00f1a {}", (Object)campaignId)).then();
    }

    private Mono<CampaignModel> sendMessageTemplateCartItem(WhatsAppTemplateRequest request, String userName, String campaignHeaderId) {
        WhatsAppCampaignModel campaign = this.buildCampaign(request);
        String phoneNumber = campaign.getTo();
        String canalAdvisor = CanalMapper.getCanal((String)request.getCanal(), (Environment)this.env);
        System.out.println(campaign);
        HistoryConversationItem userHistoryConversation = new HistoryConversationItem(phoneNumber, "whatsapp", request.getTemplate(), StatusUtil.ST_ASESOR, "CAMPANA", "User");
        return this.whatsAppService.sendMessageTemplate(campaign).flatMap(response -> {
            log.info("Response from WhatsApp API: {}", response);
            String messageId = CampaignModelUtil.extractMessageId((String)response);
            return this.stateConversationService.validateAndUpdateChatFromMetaTemplateCart(phoneNumber, canalAdvisor, request.getTemplate(), request.getCategoria(), messageId, userName, campaignHeaderId).flatMap(campaignModel -> this.historyConversationService.save(userHistoryConversation).thenReturn(campaignModel)).doOnError(e -> log.error("ERROR AL CAMBIAR EL ESTADO", e));
        }).onErrorResume(e -> {
            String fullError = ErrorParserUtil.extractErrorMessage((Throwable)e);
            return this.campaignMessageDAO.save(CampaignModelUtil.buildFailedCampaignModel((String)phoneNumber, (WhatsAppTemplateRequest)request, (String)canalAdvisor, (String)fullError, (String)userName, (String)campaignHeaderId));
        });
    }

    private Mono<CampaignModelHeader> saveCampaignHeader(List<WhatsAppTemplateRequest> listRequest, String userName) {
        WhatsAppTemplateRequest first = listRequest.get(0);
        CampaignModelHeader header = new CampaignModelHeader();
        header.setTemplateName(first.getTemplateName());
        header.setCategoryName(first.getCategoria());
        header.setUserName(userName);
        header.setSize((Number)listRequest.size());
        return this.campaignModelHeaderDAO.save(header);
    }

    private WhatsAppCampaignModel buildCampaign(WhatsAppTemplateRequest request) {
        ArrayList components = new ArrayList();
        Optional.ofNullable(request.generarHeaderComponent(request.getHeader())).ifPresent(components::add);
        Optional.ofNullable(request.generarBodyComponent(request.getBody())).ifPresent(components::add);
        Optional.ofNullable(request.generarButtonComponents(request.getButtons())).filter(buttons -> !buttons.isEmpty()).ifPresent(components::addAll);
        TemplateWhatsApp template = new TemplateWhatsApp(request.getTemplateName(), components, request.getLanguage());
        String phoneNumber = PhoneNumberUtil.validatePhoneNumber((String)request.getNumber());
        return new WhatsAppCampaignModel(phoneNumber, template);
    }

    public TemplateMessageSenderService(ApiWhatsAppService whatsAppService, MessageStateCacheService messageStateCacheService, CampaignModelHeaderDAO campaignModelHeaderDAO, StateConversationService stateConversationService, HistoryConversationItemService historyConversationService, CampaignMessageDAO campaignMessageDAO, Environment env) {
        this.whatsAppService = whatsAppService;
        this.messageStateCacheService = messageStateCacheService;
        this.campaignModelHeaderDAO = campaignModelHeaderDAO;
        this.stateConversationService = stateConversationService;
        this.historyConversationService = historyConversationService;
        this.campaignMessageDAO = campaignMessageDAO;
        this.env = env;
    }
}

