/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.data.AutomationCampaign.ACUpdate.ACUpdateCampaignDataRequest;
import com.whatsapp.campaign.data.AutomationCampaign.ACUpdate.ACUpdateScheduledCampaignRequest;
import com.whatsapp.campaign.data.CampaignDataRequest;
import com.whatsapp.campaign.data.ScheduledCampaignRequest;
import com.whatsapp.campaign.data.WhatsAppTemplateRequest;
import com.whatsapp.campaign.documents.CampaignModel;
import com.whatsapp.campaign.documents.ScheduledCampaignModel;
import com.whatsapp.campaign.dto.ReportCampaignStatuses;
import com.whatsapp.campaign.dto.scheduled.PagedScheduledCampaignResponseDTO;
import com.whatsapp.campaign.dto.scheduled.ScheduledCampaignDTO;
import com.whatsapp.campaign.dto.scheduled.ScheduledCampaignResponseDTO;
import com.whatsapp.campaign.dto.scheduled.ScheduledCampaignStatsDTO;
import com.whatsapp.campaign.repository.ScheduledCampaignRepository;
import com.whatsapp.campaign.repository.service.CampaignMessageDAO;
import com.whatsapp.campaign.service.ScheduledCampaignService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ScheduledCampaignServiceImpl
implements ScheduledCampaignService {
    private static final Logger log = LoggerFactory.getLogger(ScheduledCampaignServiceImpl.class);
    private final ScheduledCampaignRepository repository;
    private final CampaignMessageDAO campaignMessageDAO;

    public Mono<ScheduledCampaignResponseDTO> scheduleCampaign(ScheduledCampaignRequest request) {
        log.info("Scheduling campaign for: {}", (Object)request.getScheduledAt());
        if (request.getScheduledAt() != null && request.getScheduledAt().isBefore(LocalDateTime.now())) {
            return Mono.error((Throwable)new RuntimeException("Scheduled date must be in the future"));
        }
        if (request.getRecurrenceEndDate() != null && request.getRecurrenceEndDate().isBefore(LocalDateTime.now())) {
            return Mono.error((Throwable)new RuntimeException("Recurrence end date must be in the future"));
        }
        ScheduledCampaignModel model = new ScheduledCampaignModel(request.getCampaignData(), request.getScheduledAt());
        model.setRecurrenceType(request.getRecurrenceType());
        if ("INTERVAL".equalsIgnoreCase(request.getRecurrenceType())) {
            model.setRecurrenceInterval(request.getRecurrenceInterval());
        } else {
            model.setRecurrenceInterval(null);
        }
        model.setRecurrenceEndDate(request.getRecurrenceEndDate());
        model.setMetaDefinition(request.getMetaDefinition());
        if (request.getRecurrenceType() == null || "NONE".equalsIgnoreCase(request.getRecurrenceType())) {
            model.setType("SINGLE");
        } else {
            model.setType("RECURRING");
        }
        model.setSeriesId(model.getId());
        model.setSeriesName(request.getSeriesName());
        if (request.getScheduledAt() != null) {
            model.setOriginalScheduledDay(Integer.valueOf(request.getScheduledAt().getDayOfMonth()));
        }
        return this.repository.save((Object)model).map(saved -> {
            boolean isRecurring = "RECURRING".equalsIgnoreCase(saved.getType());
            if (!isRecurring) {
                return this.mapToSingleResponse(saved);
            }
            return this.mapToRecurringResponse(saved, Collections.emptyList(), Collections.emptyList());
        });
    }

    public Flux<ScheduledCampaignModel> findPendingCampaigns(LocalDateTime maxScheduledTime) {
        return this.repository.findByStatusAndScheduledAtLessThanEqual("PENDING", maxScheduledTime);
    }

    public Mono<ScheduledCampaignModel> save(ScheduledCampaignModel campaign) {
        return this.repository.save((Object)campaign);
    }

    public Mono<PagedScheduledCampaignResponseDTO<ScheduledCampaignResponseDTO>> getGroupedCampaigns(LocalDateTime start, LocalDateTime end, String seriesName, int page, int size) {
        Flux source = seriesName != null && !seriesName.trim().isEmpty() ? this.repository.findByScheduledAtBetweenAndSeriesNameContainingIgnoreCase(start, end, seriesName) : this.repository.findByScheduledAtBetween(start, end);
        return source.collectList().map(campaigns -> {
            LinkedHashMap<String, List> grouped = new LinkedHashMap<String, List>();
            for (Object c : campaigns) {
                String string = c.getSeriesId() != null ? c.getSeriesId() : c.getId();
                grouped.computeIfAbsent(string, k -> new ArrayList()).add(c);
            }
            ArrayList<ScheduledCampaignResponseDTO> responseList = new ArrayList<ScheduledCampaignResponseDTO>();
            for (Map.Entry entry : grouped.entrySet()) {
                boolean isRecurring;
                List group = (List)entry.getValue();
                group.sort((c1, c2) -> c1.getScheduledAt().compareTo(c2.getScheduledAt()));
                ScheduledCampaignModel first = (ScheduledCampaignModel)group.get(0);
                boolean bl = isRecurring = group.size() > 1 || first.getRecurrenceType() != null && !"NONE".equalsIgnoreCase(first.getRecurrenceType());
                if (!isRecurring) {
                    responseList.add(this.mapToSingleResponse(first));
                    continue;
                }
                ArrayList<LocalDateTime> missing = new ArrayList<LocalDateTime>();
                ScheduledCampaignModel last = (ScheduledCampaignModel)group.get(group.size() - 1);
                if (last.getStatus().equals("PENDING") || last.getRecurrenceEndDate() != null) {
                    LocalDateTime next = this.calculateNext(last);
                    while (!(next == null || last.getRecurrenceEndDate() != null && next.isAfter(last.getRecurrenceEndDate()) || missing.size() >= 10)) {
                        missing.add(next);
                        ScheduledCampaignModel dummy = new ScheduledCampaignModel();
                        dummy.setScheduledAt(next);
                        dummy.setRecurrenceType(last.getRecurrenceType());
                        dummy.setRecurrenceInterval(last.getRecurrenceInterval());
                        next = this.calculateNext(dummy);
                    }
                }
                responseList.add(this.mapToRecurringResponse(first, null, missing));
            }
            responseList.sort((o1, o2) -> {
                LocalDateTime d1 = o1.getSortDate();
                LocalDateTime d2 = o2.getSortDate();
                return d2.compareTo(d1);
            });
            int totalGroups = responseList.size();
            int n = page * size;
            int toGroup = Math.min(n + size, totalGroups);
            List<Object> pagedGroups = Collections.emptyList();
            if (n < totalGroups) {
                pagedGroups = responseList.subList(n, toGroup);
            }
            return this.createPagedResponseDTO(pagedGroups, page, size, (long)totalGroups);
        });
    }

    private Map<String, Object> createPagedResponse(List<?> content, int page, int size, long totalElements) {
        int totalPages = size > 0 ? (int)Math.ceil((double)totalElements / (double)size) : 0;
        boolean hasNext = (long)((page + 1) * size) < totalElements;
        boolean hasPrevious = page > 0;
        LinkedHashMap<String, Serializable> pagination = new LinkedHashMap<String, Serializable>();
        pagination.put("page", Integer.valueOf(page));
        pagination.put("size", Integer.valueOf(size));
        pagination.put("totalPages", Integer.valueOf(totalPages));
        pagination.put("totalElements", Long.valueOf(totalElements));
        pagination.put("hasNext", Boolean.valueOf(hasNext));
        pagination.put("hasPrevious", Boolean.valueOf(hasPrevious));
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("content", content);
        response.put("totalElements", totalElements);
        response.put("pagination", pagination);
        return response;
    }

    private Map<String, Object> convertCampaignToMapWithPagination(ScheduledCampaignModel model) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", model.getId());
        map.put("seriesId", model.getSeriesId());
        map.put("seriesName", model.getSeriesName());
        if (model.getCampaignData() != null) {
            LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
            dataMap.put("userName", model.getCampaignData().getUserName());
            if (model.getCampaignData().getTemplate() != null) {
                String[] parts;
                WhatsAppTemplateRequest t = model.getCampaignData().getTemplate();
                LinkedHashMap<String, String> templateMap = new LinkedHashMap<String, String>();
                templateMap.put("templateName", t.getTemplateName());
                String lang = t.getLanguage();
                if (lang != null && lang.contains("code") && lang.contains("\"") && (parts = lang.split(":")).length > 1) {
                    lang = parts[1].replaceAll("[^a-zA-Z]", "");
                }
                templateMap.put("language", lang);
                templateMap.put("canal", t.getCanal());
                templateMap.put("categoria", t.getCategoria());
                templateMap.put("header", (String)t.getHeader());
                templateMap.put("body", (String)t.getBody());
                templateMap.put("template", t.getTemplateParams() != null ? t.getTemplateParams() : t.getTemplate());
                templateMap.put("status", model.getStatus());
                dataMap.put("template", templateMap);
            }
            map.put("campaignData", dataMap);
        }
        map.put("scheduledAt", model.getScheduledAt());
        map.put("campaignHeaderId", model.getCampaignHeaderId());
        map.put("status", model.getStatus());
        map.put("createdAt", model.getCreatedAt());
        map.put("processedAt", model.getProcessedAt());
        map.put("errorMessage", model.getErrorMessage());
        map.put("recurrenceType", model.getRecurrenceType());
        map.put("recurrenceInterval", model.getRecurrenceInterval());
        map.put("recurrenceEndDate", model.getRecurrenceEndDate());
        String type = model.getRecurrenceType() != null && !"NONE".equalsIgnoreCase(model.getRecurrenceType()) ? "RECURRING" : "SINGLE";
        map.put("type", type);
        map.put("metaDefinition", model.getMetaDefinition());
        return map;
    }

    private LocalDateTime calculateNext(ScheduledCampaignModel currentModel) {
        if (currentModel.getRecurrenceType() == null || "NONE".equalsIgnoreCase(currentModel.getRecurrenceType())) {
            return null;
        }
        LocalDateTime current = currentModel.getScheduledAt();
        LocalDateTime next = null;
        switch (currentModel.getRecurrenceType().toUpperCase()) {
            case "DAILY": {
                next = current.plusDays(1L);
                break;
            }
            case "WEEKLY": {
                next = current.plusWeeks(1L);
                break;
            }
            case "MONTHLY": {
                next = current.plusMonths(1L);
                break;
            }
            case "INTERVAL": {
                if (currentModel.getRecurrenceInterval() == null || currentModel.getRecurrenceInterval() <= 0) break;
                next = current.plusDays(currentModel.getRecurrenceInterval().intValue());
            }
        }
        return next;
    }

    public Mono<Map<String, Object>> getCampaignDetail(String scheduledCampaignId, String conversationId, int page, int size) {
        return this.repository.findById((Object)scheduledCampaignId).flatMap(scheduled -> {
            Mono messagesMono;
            String headerId = scheduled.getCampaignHeaderId();
            if (headerId == null) {
                if (scheduled.getCampaignData() != null && scheduled.getCampaignData().getListCamping() != null) {
                    List pendingMessages = scheduled.getCampaignData().getListCamping().stream().map(recipient -> {
                        CampaignModel model = new CampaignModel();
                        model.setConversationId(recipient.getNumber());
                        model.setMessageStatus("pending");
                        model.setCreatedAt(scheduled.getCreatedAt());
                        model.setUserName(scheduled.getCampaignData().getUserName());
                        model.setCanal(scheduled.getCampaignData().getTemplate() != null ? scheduled.getCampaignData().getTemplate().getCanal() : null);
                        model.setCategoria(scheduled.getCampaignData().getTemplate() != null ? scheduled.getCampaignData().getTemplate().getCategoria() : null);
                        model.setMessageTemplate("Pending dispatch...");
                        model.setSend(Boolean.valueOf(false));
                        return model;
                    }).filter(msg -> conversationId == null || conversationId.isEmpty() || msg.getConversationId() != null && msg.getConversationId().contains(conversationId)).collect(Collectors.toList());
                    messagesMono = Mono.just(pendingMessages);
                } else {
                    messagesMono = Mono.just(Collections.emptyList());
                }
            } else {
                messagesMono = this.campaignMessageDAO.getCampaignsForExportByHeaderId(headerId).filter(msg -> conversationId == null || conversationId.isEmpty() || msg.getConversationId() != null && msg.getConversationId().contains(conversationId)).collectList();
            }
            return messagesMono.map(messages -> {
                LinkedHashMap<String, Map> result = new LinkedHashMap<String, Map>();
                result.put("scheduledCampaign", this.convertCampaignToMapWithPagination(scheduled));
                int totalElements = messages.size();
                int fromIndex = page * size;
                int toIndex = Math.min(fromIndex + size, totalElements);
                List<Object> pagedMessages = Collections.emptyList();
                if (fromIndex < totalElements) {
                    pagedMessages = messages.subList(fromIndex, toIndex);
                }
                Map sendCampaignPaged = this.createPagedResponse(pagedMessages, page, size, (long)totalElements);
                result.put("sendcampaign", sendCampaignPaged);
                return result;
            });
        });
    }

    public Flux<ScheduledCampaignResponseDTO> getRecurringCampaignsStats(LocalDateTime start, LocalDateTime end) {
        return this.repository.findByScheduledAtBetween(start, end).collectList().flatMapMany(campaigns -> {
            LinkedHashMap<String, List> grouped = new LinkedHashMap<String, List>();
            for (ScheduledCampaignModel c : campaigns) {
                String key = c.getSeriesId() != null ? c.getSeriesId() : c.getId();
                grouped.computeIfAbsent(key, k -> new ArrayList()).add(c);
            }
            return Flux.fromIterable(grouped.entrySet()).filter(entry -> {
                List list = (List)entry.getValue();
                ScheduledCampaignModel first = (ScheduledCampaignModel)list.get(0);
                return list.size() > 1 || first.getRecurrenceType() != null && !"NONE".equalsIgnoreCase(first.getRecurrenceType());
            }).concatMap(entry -> {
                List list = (List)entry.getValue();
                List headerIds = list.stream().map(ScheduledCampaignModel::getCampaignHeaderId).filter(h -> h != null && !h.isEmpty()).collect(Collectors.toList());
                Mono statsMono = headerIds.isEmpty() ? Mono.just((Object)new ScheduledCampaignStatsDTO(0L, 0L, 0L, 0L, 0L)) : this.campaignMessageDAO.findMessageStatusCountsByHeaderIds(headerIds).collectList().map(counts -> {
                    long leido = 0L;
                    long entregado = 0L;
                    long error = 0L;
                    long meta = 0L;
                    long total = 0L;
                    for (ReportCampaignStatuses s : counts) {
                        String status = s.getMessageStatus() != null ? s.getMessageStatus().toLowerCase() : "unknown";
                        long count = s.getCount() != null ? (long)s.getCount().intValue() : 0L;
                        total += count;
                        if (status.equals("read")) {
                            leido += count;
                            continue;
                        }
                        if (status.equals("delivered")) {
                            entregado += count;
                            continue;
                        }
                        if (status.equals("failed") || status.equals("error") || status.equals("undeliverable")) {
                            error += count;
                            continue;
                        }
                        meta += count;
                    }
                    return new ScheduledCampaignStatsDTO(leido, entregado, error, meta, total);
                });
                return statsMono.map(stats -> {
                    ScheduledCampaignModel first = (ScheduledCampaignModel)list.get(0);
                    List done = list.stream().filter(c -> "COMPLETED".equalsIgnoreCase(c.getStatus())).sorted((c1, c2) -> c1.getScheduledAt().compareTo(c2.getScheduledAt())).map(arg_0 -> this.mapToDTO(arg_0)).collect(Collectors.toList());
                    ScheduledCampaignResponseDTO response = this.mapToRecurringResponse(first, done, Collections.emptyList());
                    response.setStats(stats);
                    return response;
                });
            });
        });
    }

    public Mono<ScheduledCampaignModel> updateScheduledCampaign(String id, ACUpdateScheduledCampaignRequest request) {
        return this.repository.findById((Object)id).switchIfEmpty(Mono.error((Throwable)new RuntimeException("Campaign not found"))).flatMap(existing -> {
            if (!"PENDING".equalsIgnoreCase(existing.getStatus()) && !"ERROR".equalsIgnoreCase(existing.getStatus())) {
                return Mono.error((Throwable)new RuntimeException("Cannot edit a campaign that is already " + existing.getStatus()));
            }
            ACUpdateCampaignDataRequest newDataUpdate = request.getCampaignData();
            CampaignDataRequest newData = new CampaignDataRequest();
            if (existing.getCampaignData() != null) {
                CampaignDataRequest oldData = existing.getCampaignData();
                newData.setTemplate(oldData.getTemplate());
                newData.setListCamping(oldData.getListCamping());
                newData.setUserName(oldData.getUserName());
            }
            if (newDataUpdate != null) {
                if (newDataUpdate.getUserName() != null) {
                    newData.setUserName(newDataUpdate.getUserName());
                }
                if (newDataUpdate.getListCamping() != null && !newDataUpdate.getListCamping().isEmpty()) {
                    newData.setListCamping(newDataUpdate.getListCamping());
                }
                if (newDataUpdate.getTemplate() != null) {
                    if (newData.getTemplate() != null) {
                        newData.getTemplate().setCanal(newDataUpdate.getTemplate().getCanal());
                    } else {
                        WhatsAppTemplateRequest newTemplate = new WhatsAppTemplateRequest();
                        newTemplate.setCanal(newDataUpdate.getTemplate().getCanal());
                        newData.setTemplate(newTemplate);
                    }
                }
            }
            existing.setCampaignData(newData);
            if (request.getScheduledAt() != null) {
                if (request.getScheduledAt().isBefore(LocalDateTime.now())) {
                    return Mono.error((Throwable)new RuntimeException("Scheduled date must be in the future"));
                }
                existing.setScheduledAt(request.getScheduledAt());
                existing.setOriginalScheduledDay(Integer.valueOf(request.getScheduledAt().getDayOfMonth()));
            }
            if (request.getRecurrenceType() != null) {
                if ("SINGLE".equalsIgnoreCase(existing.getType()) && !"NONE".equalsIgnoreCase(request.getRecurrenceType())) {
                    log.warn("Attempt to change SINGLE campaign {} to RECURRING ignored.", (Object)id);
                } else {
                    existing.setRecurrenceType(request.getRecurrenceType());
                    if ("INTERVAL".equalsIgnoreCase(request.getRecurrenceType())) {
                        existing.setRecurrenceInterval(request.getRecurrenceInterval());
                    } else {
                        existing.setRecurrenceInterval(null);
                    }
                    if (request.getRecurrenceEndDate() != null && request.getRecurrenceEndDate().isBefore(LocalDateTime.now())) {
                        return Mono.error((Throwable)new RuntimeException("Recurrence end date must be in the future"));
                    }
                    existing.setRecurrenceEndDate(request.getRecurrenceEndDate());
                    if (!"NONE".equalsIgnoreCase(request.getRecurrenceType())) {
                        existing.setType("RECURRING");
                    } else {
                        existing.setType("SINGLE");
                    }
                }
            }
            if (request.getSeriesName() != null) {
                existing.setSeriesName(request.getSeriesName());
            }
            if (request.getProgramerType() != null) {
                if ("single".equalsIgnoreCase(request.getProgramerType())) {
                    existing.setType("SINGLE");
                    existing.setRecurrenceType("NONE");
                    existing.setRecurrenceInterval(Integer.valueOf(0));
                    existing.setRecurrenceEndDate(null);
                } else if ("recurrent".equalsIgnoreCase(request.getProgramerType())) {
                    existing.setType("RECURRING");
                    if ((existing.getRecurrenceType() == null || "NONE".equalsIgnoreCase(existing.getRecurrenceType())) && request.getRecurrenceType() != null) {
                        existing.setRecurrenceType(request.getRecurrenceType());
                    }
                }
            }
            log.info("Updating campaign {}", (Object)id);
            return this.repository.save(existing);
        });
    }

    public Mono<ScheduledCampaignModel> updateStatus(String id, String newStatus) {
        return this.repository.findById((Object)id).switchIfEmpty(Mono.error((Throwable)new RuntimeException("Campaign not found"))).flatMap(campaign -> {
            if ("PROCESSING".equalsIgnoreCase(campaign.getStatus()) || "COMPLETED".equalsIgnoreCase(campaign.getStatus())) {
                return Mono.error((Throwable)new RuntimeException("Cannot change status of a " + campaign.getStatus() + " campaign"));
            }
            String normalizedStatus = newStatus.toUpperCase();
            if (!List.of("PENDING", "PAUSED", "CANCELLED").contains(normalizedStatus)) {
                return Mono.error((Throwable)new RuntimeException("Invalid status. Allowed: PENDING, PAUSED, CANCELLED"));
            }
            campaign.setStatus(normalizedStatus);
            log.info("Changing campaign {} status to {}", (Object)id, (Object)normalizedStatus);
            return this.repository.save(campaign);
        });
    }

    public Mono<ScheduledCampaignModel> findById(String id) {
        return this.repository.findById((Object)id);
    }

    public Mono<PagedScheduledCampaignResponseDTO<ScheduledCampaignResponseDTO>> getSeriesHistory(String seriesId, int page, int size) {
        return this.repository.findBySeriesId(seriesId).collectList().flatMap(campaigns -> {
            campaigns.sort((c1, c2) -> c2.getScheduledAt().compareTo(c1.getScheduledAt()));
            int totalElements = campaigns.size();
            int fromIndex = page * size;
            int toIndex = Math.min(fromIndex + size, totalElements);
            if (fromIndex >= totalElements) {
                return Mono.just((Object)this.createPagedResponseDTO(Collections.emptyList(), page, size, (long)totalElements));
            }
            List pagedModels = campaigns.subList(fromIndex, toIndex);
            return Flux.fromIterable(pagedModels).flatMap(model -> {
                Mono statsMono = model.getCampaignHeaderId() == null ? Mono.just((Object)new ScheduledCampaignStatsDTO(0L, 0L, 0L, 0L, 0L)) : this.campaignMessageDAO.getCampaignsForExportByHeaderId(model.getCampaignHeaderId()).collectList().map(messages -> {
                    long leido = 0L;
                    long entregado = 0L;
                    long error = 0L;
                    long meta = 0L;
                    long total = messages.size();
                    for (CampaignModel msg : messages) {
                        String s = msg.getMessageStatus();
                        if (s == null) {
                            s = "unknown";
                        }
                        if ((s = s.toLowerCase()).equals("read")) {
                            ++leido;
                            continue;
                        }
                        if (s.equals("delivered")) {
                            ++entregado;
                            continue;
                        }
                        if (s.equals("failed") || s.equals("error") || s.equals("undeliverable")) {
                            ++error;
                            continue;
                        }
                        ++meta;
                    }
                    return new ScheduledCampaignStatsDTO(leido, entregado, error, meta, total);
                });
                return statsMono.map(stats -> {
                    ScheduledCampaignResponseDTO dto = this.mapToSingleResponse(model);
                    dto.setStats(stats);
                    return dto;
                });
            }).collectList().map(pagedContent -> this.createPagedResponseDTO(pagedContent, page, size, (long)totalElements));
        });
    }

    public Mono<ScheduledCampaignStatsDTO> getCampaignStats(String id) {
        return this.repository.findById((Object)id).switchIfEmpty(Mono.error((Throwable)new RuntimeException("Campaign not found"))).flatMap(campaign -> {
            if (campaign.getCampaignHeaderId() == null) {
                return Mono.just((Object)new ScheduledCampaignStatsDTO(0L, 0L, 0L, 0L, 0L));
            }
            return this.campaignMessageDAO.getCampaignsForExportByHeaderId(campaign.getCampaignHeaderId()).collectList().map(messages -> {
                long leido = 0L;
                long entregado = 0L;
                long error = 0L;
                long meta = 0L;
                long total = messages.size();
                for (CampaignModel msg : messages) {
                    String s = msg.getMessageStatus();
                    if (s == null) {
                        s = "unknown";
                    }
                    if ((s = s.toLowerCase()).equals("read")) {
                        ++leido;
                        continue;
                    }
                    if (s.equals("delivered")) {
                        ++entregado;
                        continue;
                    }
                    if (s.equals("failed") || s.equals("error") || s.equals("undeliverable")) {
                        ++error;
                        continue;
                    }
                    ++meta;
                }
                return new ScheduledCampaignStatsDTO(leido, entregado, error, meta, total);
            });
        });
    }

    public Mono<ScheduledCampaignModel> getEditableCampaignBySeriesId(String seriesId) {
        return this.repository.findBySeriesId(seriesId).collectList().flatMap(campaigns -> {
            List pending = campaigns.stream().filter(c -> "PENDING".equalsIgnoreCase(c.getStatus())).sorted((c1, c2) -> c1.getScheduledAt().compareTo(c2.getScheduledAt())).collect(Collectors.toList());
            if (pending.isEmpty()) {
                return Mono.error((Throwable)new RuntimeException("No editable (PENDING) campaign found for series: " + seriesId));
            }
            return Mono.just((Object)((ScheduledCampaignModel)pending.get(0)));
        });
    }

    private ScheduledCampaignDTO mapToDTO(ScheduledCampaignModel model) {
        return ScheduledCampaignDTO.builder().id(model.getId()).seriesId(model.getSeriesId()).seriesName(model.getSeriesName()).scheduledAt(model.getScheduledAt()).status(model.getStatus()).recurrenceType(model.getRecurrenceType()).recurrenceInterval(model.getRecurrenceInterval()).recurrenceEndDate(model.getRecurrenceEndDate()).metaDefinition(model.getMetaDefinition()).campaignData(model.getCampaignData()).campaignHeaderId(model.getCampaignHeaderId()).createdAt(model.getCreatedAt()).processedAt(model.getProcessedAt()).errorMessage(model.getErrorMessage()).build();
    }

    private ScheduledCampaignResponseDTO mapToSingleResponse(ScheduledCampaignModel model) {
        return ScheduledCampaignResponseDTO.builder().type("SINGLE").seriesId(model.getSeriesId() != null ? model.getSeriesId() : model.getId()).seriesName(model.getSeriesName()).createdAt(model.getCreatedAt()).campaign(this.mapToDTO(model)).sortDate(model.getScheduledAt()).build();
    }

    private ScheduledCampaignResponseDTO mapToRecurringResponse(ScheduledCampaignModel first, List<ScheduledCampaignDTO> history, List<LocalDateTime> missing) {
        return ScheduledCampaignResponseDTO.builder().type("RECURRING").seriesId(first.getSeriesId() != null ? first.getSeriesId() : first.getId()).seriesName(first.getSeriesName()).createdAt(first.getCreatedAt()).recurrenceType(first.getRecurrenceType()).recurrenceInterval(first.getRecurrenceInterval()).recurrenceEndDate(first.getRecurrenceEndDate()).history(history).missing(missing).sortDate(first.getScheduledAt()).build();
    }

    private <T> PagedScheduledCampaignResponseDTO<T> createPagedResponseDTO(List<T> content, int page, int size, long totalElements) {
        int totalPages = size > 0 ? (int)Math.ceil((double)totalElements / (double)size) : 0;
        boolean hasNext = (long)((page + 1) * size) < totalElements;
        boolean hasPrevious = page > 0;
        return PagedScheduledCampaignResponseDTO.builder().content(content).totalElements(totalElements).totalPages(totalPages).page(page).size(size).hasNext(hasNext).hasPrevious(hasPrevious).build();
    }

    public ScheduledCampaignServiceImpl(ScheduledCampaignRepository repository, CampaignMessageDAO campaignMessageDAO) {
        this.repository = repository;
        this.campaignMessageDAO = campaignMessageDAO;
    }
}

