/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.documents.HistoryConversation;
import com.whatsapp.campaign.repository.HistoryConversationRepository;
import com.whatsapp.campaign.service.HistoryConversationService;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class HistoryConversationServiceImpl
implements HistoryConversationService {
    private static final Logger log = LoggerFactory.getLogger(HistoryConversationServiceImpl.class);
    private final HistoryConversationRepository historyConversationRepository;

    public Mono<Void> save(HistoryConversation historyConversation) {
        return this.historyConversationRepository.findByIdPlatform(historyConversation.getIdPlatform()).flatMap(existingConversation -> {
            if (historyConversation.getNick() != null && !historyConversation.getNick().equalsIgnoreCase("User")) {
                existingConversation.setNick(historyConversation.getNick());
            }
            if (historyConversation.getPlatform() == null) {
                existingConversation.setPlatform("whatsapp");
            } else {
                existingConversation.setPlatform(historyConversation.getPlatform());
            }
            existingConversation.setUpdatedAt(LocalDateTime.now());
            return this.historyConversationRepository.save(existingConversation);
        }).switchIfEmpty(this.historyConversationRepository.save((Object)historyConversation)).doOnSuccess(response -> log.info("HistoryConversation saved or updated: {}", response)).then().onErrorResume(error -> {
            log.error("Error saving or updating HistoryConversation: {}", (Object)error.getMessage());
            return Mono.empty();
        });
    }

    public Mono<String> getNickByIdPlatform(String idPlatform) {
        return this.historyConversationRepository.findByIdPlatform(idPlatform).map(HistoryConversation::getNick).defaultIfEmpty((Object)"User");
    }

    public HistoryConversationServiceImpl(HistoryConversationRepository historyConversationRepository) {
        this.historyConversationRepository = historyConversationRepository;
    }
}

