/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.documents.HistoryConversation;
import com.whatsapp.campaign.documents.HistoryConversationItem;
import com.whatsapp.campaign.helpers.HistoryConversationItemHelper;
import com.whatsapp.campaign.repository.HistoryConversationItemRepository;
import com.whatsapp.campaign.service.HistoryConversationItemService;
import com.whatsapp.campaign.service.HistoryConversationService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class HistoryConversationItemServiceImpl
implements HistoryConversationItemService {
    private static final Logger log = LoggerFactory.getLogger(HistoryConversationItemServiceImpl.class);
    private final HistoryConversationItemRepository historyConversationItemRepository;
    private final HistoryConversationService historyConversationService;
    private final HistoryConversationItemHelper historyConversationItemHelper;

    public Mono<String> getMessageByMetaId(String metaId) {
        return this.historyConversationItemRepository.findByMessageMetaId(metaId).map(HistoryConversationItem::getMessage).switchIfEmpty(Mono.just((Object)"No se encontr\u00f3 el mensaje respondido"));
    }

    public Mono<Void> save(HistoryConversationItem historyConversation) {
        log.info("Attempting to save HistoryConversation with createdAt: {}", (Object)historyConversation.getConversationId());
        return this.historyConversationItemRepository.save((Object)historyConversation).doOnSuccess(response -> log.info("UserResponse saved: {}", response)).then(this.historyConversationService.save(new HistoryConversation(historyConversation.getIdPlatform(), historyConversation.getNick(), historyConversation.getPlatform()))).onErrorResume(error -> {
            log.error("Error saving UserResponse: {}", (Object)error.getMessage());
            return Mono.empty();
        });
    }

    public Flux<Map<String, Object>> getMessagesCountByDay(String startDateParam, String endDateParam) {
        return this.historyConversationItemHelper.getMessagesCountByDay(startDateParam, endDateParam);
    }

    public Mono<Map<String, Object>> getReportInformationConversations(String startDateParam, String endDateParam) {
        Mono usersSessionCountMono = this.historyConversationItemHelper.getUsersCountByDay(startDateParam, endDateParam);
        Mono messagesCountBot = this.historyConversationItemHelper.getMessagesCountByRoleAndDateRange(startDateParam, endDateParam, List.of("BOT", "LHIA"));
        Mono messagesCountAssessor = this.historyConversationItemHelper.getMessagesCountByRoleAndDateRange(startDateParam, endDateParam, List.of("ASESOR"));
        Mono messagesCountUser = this.historyConversationItemHelper.getMessagesCountByRoleAndDateRange(startDateParam, endDateParam, List.of("USER"));
        return Mono.zip((Mono)usersSessionCountMono, (Mono)messagesCountBot, (Mono)messagesCountAssessor, (Mono)messagesCountUser).map(tuple -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("userSession", tuple.getT1());
            result.put("messagesBot", tuple.getT2());
            result.put("messagesAssessor", tuple.getT3());
            result.put("messagesUser", tuple.getT4());
            return result;
        });
    }

    public HistoryConversationItemServiceImpl(HistoryConversationItemRepository historyConversationItemRepository, HistoryConversationService historyConversationService, HistoryConversationItemHelper historyConversationItemHelper) {
        this.historyConversationItemRepository = historyConversationItemRepository;
        this.historyConversationService = historyConversationService;
        this.historyConversationItemHelper = historyConversationItemHelper;
    }
}

