/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.scheduler;

import com.whatsapp.campaign.documents.ScheduledCampaignModel;
import com.whatsapp.campaign.service.ScheduledCampaignService;
import com.whatsapp.campaign.service.TemplateService;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class CampaignScheduler {
    private static final Logger log = LoggerFactory.getLogger(CampaignScheduler.class);
    private final ScheduledCampaignService scheduledCampaignService;
    private final TemplateService templateService;

    @Scheduled(fixedDelay=60000L)
    public void processScheduledCampaigns() {
        this.scheduledCampaignService.findPendingCampaigns(LocalDateTime.now()).flatMap(campaign -> {
            log.info("Processing scheduled campaign id: {}", (Object)campaign.getId());
            if (campaign.getScheduledAt() != null && campaign.getScheduledAt().isBefore(LocalDateTime.now().minusHours(24L))) {
                log.info("Campaign {} is stale (>24h old). Skipping send and advancing recurrence.", (Object)campaign.getId());
                campaign.setStatus("SKIPPED");
                campaign.setErrorMessage("Skipped due to being stale (>24h delay)");
                campaign.setProcessedAt(LocalDateTime.now());
                return this.scheduledCampaignService.save(campaign).flatMap(arg_0 -> this.handleRecurrence(arg_0));
            }
            campaign.setStatus("PROCESSING");
            return this.scheduledCampaignService.save(campaign).flatMap(processingCampaign -> this.templateService.sendTemplateBatch(processingCampaign.getCampaignData()).flatMap(headerId -> {
                processingCampaign.setCampaignHeaderId(headerId);
                processingCampaign.setStatus("COMPLETED");
                processingCampaign.setProcessedAt(LocalDateTime.now());
                return this.scheduledCampaignService.save(processingCampaign).flatMap(arg_0 -> this.handleRecurrence(arg_0));
            }).onErrorResume(e -> {
                log.error("Error processing campaign {}: {}", (Object)campaign.getId(), (Object)e.getMessage());
                processingCampaign.setStatus("ERROR");
                processingCampaign.setErrorMessage(e.getMessage());
                processingCampaign.setProcessedAt(LocalDateTime.now());
                return this.scheduledCampaignService.save(processingCampaign);
            }));
        }).subscribe();
    }

    private Mono<ScheduledCampaignModel> handleRecurrence(ScheduledCampaignModel completedCampaign) {
        if (completedCampaign.getRecurrenceType() == null || "NONE".equalsIgnoreCase(completedCampaign.getRecurrenceType())) {
            return Mono.just((Object)completedCampaign);
        }
        LocalDateTime nextScheduled = null;
        LocalDateTime current = completedCampaign.getScheduledAt();
        switch (completedCampaign.getRecurrenceType().toUpperCase()) {
            case "DAILY": {
                nextScheduled = current.plusDays(1L);
                break;
            }
            case "WEEKLY": {
                nextScheduled = current.plusWeeks(1L);
                break;
            }
            case "MONTHLY": {
                LocalDateTime targetDate = current.plusMonths(1L);
                Integer origDay = completedCampaign.getOriginalScheduledDay();
                if (origDay != null) {
                    int lastDayOfTargetMonth = targetDate.toLocalDate().lengthOfMonth();
                    int targetDayToSet = Math.min(origDay, lastDayOfTargetMonth);
                    nextScheduled = targetDate.withDayOfMonth(targetDayToSet);
                    break;
                }
                nextScheduled = targetDate;
                break;
            }
            case "INTERVAL": {
                if (completedCampaign.getRecurrenceInterval() == null || completedCampaign.getRecurrenceInterval() <= 0) break;
                nextScheduled = current.plusDays(completedCampaign.getRecurrenceInterval().intValue());
                break;
            }
        }
        if (nextScheduled != null) {
            if (completedCampaign.getRecurrenceEndDate() != null && nextScheduled.isAfter(completedCampaign.getRecurrenceEndDate())) {
                log.info("Recurrence ended for campaign {}", (Object)completedCampaign.getId());
                return Mono.just((Object)completedCampaign);
            }
            ScheduledCampaignModel nextCampaign = new ScheduledCampaignModel(completedCampaign.getCampaignData(), nextScheduled);
            nextCampaign.setRecurrenceType(completedCampaign.getRecurrenceType());
            nextCampaign.setRecurrenceInterval(completedCampaign.getRecurrenceInterval());
            nextCampaign.setRecurrenceEndDate(completedCampaign.getRecurrenceEndDate());
            nextCampaign.setSeriesId(completedCampaign.getSeriesId());
            nextCampaign.setOriginalScheduledDay(completedCampaign.getOriginalScheduledDay());
            log.info("Scheduling next recurrence for campaign {} at {}", (Object)completedCampaign.getId(), (Object)nextScheduled);
            return this.scheduledCampaignService.save(nextCampaign).thenReturn((Object)completedCampaign);
        }
        return Mono.just((Object)completedCampaign);
    }

    public CampaignScheduler(ScheduledCampaignService scheduledCampaignService, TemplateService templateService) {
        this.scheduledCampaignService = scheduledCampaignService;
        this.templateService = templateService;
    }
}

