/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.repository.service;

import com.whatsapp.campaign.documents.CampaignModel;
import com.whatsapp.campaign.documents.CampaignModelHeader;
import com.whatsapp.campaign.dto.DailyCountDTO;
import com.whatsapp.campaign.dto.ErrorCampaignDetail;
import com.whatsapp.campaign.dto.ReportCampaignStatuses;
import com.whatsapp.campaign.repository.CampaignMessageReposotory;
import com.whatsapp.campaign.repository.CampaignReactiveReportRepository;
import com.whatsapp.campaign.utils.DateUtils;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class CampaignMessageDAO {
    private static final Logger log = LoggerFactory.getLogger(CampaignMessageDAO.class);
    private final CampaignMessageReposotory campaignMessageRepository;
    private final CampaignReactiveReportRepository campaignReactiveReportRepository;

    public Mono<List<ErrorCampaignDetail>> filterNumbersWithError(List<String> conversationIds) {
        return this.campaignReactiveReportRepository.filterNumbersWithError(conversationIds);
    }

    public Mono<List<ReportCampaignStatuses>> obtenerEstadisticaPorEstados(LocalDateTime startDate, LocalDateTime finalDate) {
        LocalDateTime initDate = DateUtils.setToStartOfDay((LocalDateTime)startDate);
        LocalDateTime endDate = DateUtils.setToEndOfDay((LocalDateTime)finalDate);
        return this.campaignReactiveReportRepository.getMessageStatusCounts(initDate, endDate);
    }

    public Mono<CampaignModel> save(CampaignModel campaignModel) {
        return this.campaignMessageRepository.save((Object)campaignModel);
    }

    public Flux<DailyCountDTO> obtenerReporteDiario(LocalDate inicio, LocalDate fin) {
        return this.campaignReactiveReportRepository.getDailyCounts(inicio, fin);
    }

    public Mono<CampaignModel> findByMessageId(String messageId) {
        return this.campaignMessageRepository.findByMessageId(messageId);
    }

    public Flux<CampaignModel> findByCampaignHeaderId(String campaignHeaderId, Pageable pageable) {
        return this.campaignMessageRepository.findByCampaignHeaderId(campaignHeaderId, pageable);
    }

    public Mono<Long> countByCampaignHeaderId(String campaignHeaderId) {
        return this.campaignMessageRepository.countByCampaignHeaderId(campaignHeaderId);
    }

    public Flux<CampaignModel> getCampaignsForExportByHeaderId(String campaignHeaderId) {
        return this.campaignMessageRepository.getByCampaignHeaderId(campaignHeaderId);
    }

    public Mono<String> getUserNameByConversationIdAndCanal(String conversationId, String canal) {
        return this.campaignMessageRepository.findFirstByConversationIdAndCanalOrderByCreatedAtDesc(conversationId, canal).flatMap(campaign -> {
            if (campaign.getUserName() == null) {
                log.warn("Campa\u00f1a encontrada sin userName - conversationId: {}, canal: {}", (Object)conversationId, (Object)canal);
                return Mono.empty();
            }
            Duration elapsed = Duration.between(campaign.getCreatedAt(), LocalDateTime.now());
            if (elapsed.toHours() < 24L) {
                log.info("Asignando agente '{}' desde campa\u00f1a v\u00e1lida ({}h)", (Object)campaign.getUserName(), (Object)elapsed.toHours());
                return Mono.just((Object)campaign.getUserName());
            }
            log.info("Campa\u00f1a descartada por antig\u00fcedad: {}h - conversationId: {}, canal: {}", new Object[]{elapsed.toHours(), conversationId, canal});
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> {
            log.info("No se asigna agente desde campa\u00f1a (no encontrada o inv\u00e1lida) - conversationId: {}, canal: {}", (Object)conversationId, (Object)canal);
            return Mono.empty();
        }));
    }

    public Mono<List<CampaignModel>> getAllCampaigns() {
        return this.campaignMessageRepository.findAll().collectList();
    }

    public Flux<CampaignModel> findByConversationIdAndCreatedAtBetween(String conversationId, LocalDateTime from, LocalDateTime to) {
        return this.campaignMessageRepository.findByConversationIdAndCreatedAtBetween(conversationId, from, to);
    }

    public Flux<CampaignModel> findByConversationIdAndCreatedAtBetween(String conversationId, LocalDateTime from, LocalDateTime to, Pageable pageable) {
        return this.campaignMessageRepository.findByConversationIdAndCreatedAtBetween(conversationId, from, to, pageable);
    }

    public Mono<Long> countByConversationIdAndCreatedAtBetween(String conversationId, LocalDateTime from, LocalDateTime to) {
        return this.campaignMessageRepository.countByConversationIdAndCreatedAtBetween(conversationId, from, to);
    }

    public Mono<CampaignModelHeader> getCampaignModelHeaderById(String headerId) {
        return this.campaignReactiveReportRepository.getCampaignModelHeaderById(headerId);
    }

    public Flux<ReportCampaignStatuses> findMessageStatusCountsByHeaderIds(List<String> headerIds) {
        return this.campaignReactiveReportRepository.findMessageStatusCountsByHeaderIds(headerIds);
    }

    public CampaignMessageDAO(CampaignMessageReposotory campaignMessageRepository, CampaignReactiveReportRepository campaignReactiveReportRepository) {
        this.campaignMessageRepository = campaignMessageRepository;
        this.campaignReactiveReportRepository = campaignReactiveReportRepository;
    }
}

