/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.repository;

import com.whatsapp.campaign.documents.CampaignModelHeader;
import com.whatsapp.campaign.dto.DailyCountDTO;
import com.whatsapp.campaign.dto.ErrorCampaignDetail;
import com.whatsapp.campaign.dto.ReportCampaignStatuses;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import org.bson.Document;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Repository;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Repository
public class CampaignReactiveReportRepository {
    private final ReactiveMongoTemplate reactiveMongoTemplate;

    public Mono<List<ErrorCampaignDetail>> filterNumbersWithError(List<String> conversationIds) {
        MatchOperation match = Aggregation.match((Criteria)Criteria.where((String)"conversationId").in(conversationIds).and("messageStatus").nin(new Object[]{"read", "delivered"}));
        GroupOperation group = Aggregation.group((String[])new String[]{"conversationId"}).last("conversationId").as("conversationId").last("messageError").as("messageError").last("createdAt").as("createdAt").last("messageStatus").as("messageStatus");
        ProjectionOperation project = Aggregation.project((String[])new String[0]).and("conversationId").as("conversationId").and("messageError").as("messageError").and("createdAt").as("createdAt").and("messageStatus").as("messageStatus");
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, group, project});
        return this.reactiveMongoTemplate.aggregate(aggregation, "campaign_model", ErrorCampaignDetail.class).collectList();
    }

    public Mono<List<ReportCampaignStatuses>> getMessageStatusCounts(LocalDateTime startDate, LocalDateTime endDate) {
        MatchOperation match = Aggregation.match((Criteria)Criteria.where((String)"messageStatus").exists(true).and("createdAt").gte((Object)startDate).lte((Object)endDate));
        GroupOperation group = Aggregation.group((String[])new String[]{"messageStatus"}).count().as("count").first("messageStatus").as("messageStatus");
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, group});
        return this.reactiveMongoTemplate.aggregate(aggregation, "campaign_model", ReportCampaignStatuses.class).collectList();
    }

    public Flux<DailyCountDTO> getDailyCounts(LocalDate start, LocalDate end) {
        Date startDate = Date.from(start.atStartOfDay().toInstant(ZoneOffset.UTC));
        Date endDate = Date.from(end.atTime(23, 59, 59).toInstant(ZoneOffset.UTC));
        MatchOperation match = Aggregation.match((Criteria)Criteria.where((String)"createdAt").gte((Object)startDate).lte((Object)endDate));
        ProjectionOperation project = Aggregation.project((String[])new String[0]).andExpression("dateToString('%Y-%m-%d', createdAt)", new Object[0]).as("date");
        GroupOperation group = Aggregation.group((String[])new String[]{"date"}).count().as("total");
        SortOperation sort = Aggregation.sort((Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, project, group, sort});
        return this.reactiveMongoTemplate.aggregate(aggregation, "campaign_model", Document.class).map(doc -> new DailyCountDTO(doc.getString((Object)"_id"), (long)doc.getInteger((Object)"total").intValue()));
    }

    public Mono<CampaignModelHeader> getCampaignModelHeaderById(String headerId) {
        return this.reactiveMongoTemplate.findById((Object)headerId, CampaignModelHeader.class);
    }

    public Flux<ReportCampaignStatuses> findMessageStatusCountsByHeaderIds(List<String> headerIds) {
        MatchOperation match = Aggregation.match((Criteria)Criteria.where((String)"campaignHeaderId").in(headerIds));
        GroupOperation group = Aggregation.group((String[])new String[]{"messageStatus"}).count().as("count").first("messageStatus").as("messageStatus");
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, group});
        return this.reactiveMongoTemplate.aggregate(aggregation, "campaign_model", ReportCampaignStatuses.class);
    }

    public CampaignReactiveReportRepository(ReactiveMongoTemplate reactiveMongoTemplate) {
        this.reactiveMongoTemplate = reactiveMongoTemplate;
    }
}

