/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.documents;

import com.whatsapp.campaign.data.CampaignDataRequest;
import com.whatsapp.campaign.data.CampaignMetaDefinition;
import java.time.LocalDateTime;
import java.util.UUID;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="scheduled_campaigns")
public class ScheduledCampaignModel {
    @Id
    private String id;
    private String seriesId;
    private String type;
    private CampaignDataRequest campaignData;
    @Indexed
    private LocalDateTime scheduledAt;
    private String campaignHeaderId;
    private String status;
    private LocalDateTime createdAt;
    private LocalDateTime processedAt;
    private String errorMessage;
    private String recurrenceType;
    private Integer recurrenceInterval;
    private LocalDateTime recurrenceEndDate;
    private String seriesName;
    private Integer originalScheduledDay;
    private CampaignMetaDefinition metaDefinition;

    public ScheduledCampaignModel(CampaignDataRequest campaignData, LocalDateTime scheduledAt) {
        this.id = UUID.randomUUID().toString();
        this.campaignData = campaignData;
        this.scheduledAt = scheduledAt;
        this.status = "PENDING";
        this.createdAt = LocalDateTime.now();
    }

    public boolean getMasive() {
        return this.campaignData != null && this.campaignData.getListCamping() != null && this.campaignData.getListCamping().size() > 1;
    }

    public String getProgramerType() {
        return "RECURRING".equalsIgnoreCase(this.type) ? "recurrent" : "single";
    }

    public String getId() {
        return this.id;
    }

    public String getSeriesId() {
        return this.seriesId;
    }

    public String getType() {
        return this.type;
    }

    public CampaignDataRequest getCampaignData() {
        return this.campaignData;
    }

    public LocalDateTime getScheduledAt() {
        return this.scheduledAt;
    }

    public String getCampaignHeaderId() {
        return this.campaignHeaderId;
    }

    public String getStatus() {
        return this.status;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getProcessedAt() {
        return this.processedAt;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getRecurrenceType() {
        return this.recurrenceType;
    }

    public Integer getRecurrenceInterval() {
        return this.recurrenceInterval;
    }

    public LocalDateTime getRecurrenceEndDate() {
        return this.recurrenceEndDate;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public Integer getOriginalScheduledDay() {
        return this.originalScheduledDay;
    }

    public CampaignMetaDefinition getMetaDefinition() {
        return this.metaDefinition;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSeriesId(String seriesId) {
        this.seriesId = seriesId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCampaignData(CampaignDataRequest campaignData) {
        this.campaignData = campaignData;
    }

    public void setScheduledAt(LocalDateTime scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    public void setCampaignHeaderId(String campaignHeaderId) {
        this.campaignHeaderId = campaignHeaderId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setProcessedAt(LocalDateTime processedAt) {
        this.processedAt = processedAt;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setRecurrenceType(String recurrenceType) {
        this.recurrenceType = recurrenceType;
    }

    public void setRecurrenceInterval(Integer recurrenceInterval) {
        this.recurrenceInterval = recurrenceInterval;
    }

    public void setRecurrenceEndDate(LocalDateTime recurrenceEndDate) {
        this.recurrenceEndDate = recurrenceEndDate;
    }

    public void setSeriesName(String seriesName) {
        this.seriesName = seriesName;
    }

    public void setOriginalScheduledDay(Integer originalScheduledDay) {
        this.originalScheduledDay = originalScheduledDay;
    }

    public void setMetaDefinition(CampaignMetaDefinition metaDefinition) {
        this.metaDefinition = metaDefinition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduledCampaignModel)) {
            return false;
        }
        ScheduledCampaignModel other = (ScheduledCampaignModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$recurrenceInterval = this.getRecurrenceInterval();
        Integer other$recurrenceInterval = other.getRecurrenceInterval();
        if (this$recurrenceInterval == null ? other$recurrenceInterval != null : !((Object)this$recurrenceInterval).equals(other$recurrenceInterval)) {
            return false;
        }
        Integer this$originalScheduledDay = this.getOriginalScheduledDay();
        Integer other$originalScheduledDay = other.getOriginalScheduledDay();
        if (this$originalScheduledDay == null ? other$originalScheduledDay != null : !((Object)this$originalScheduledDay).equals(other$originalScheduledDay)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$seriesId = this.getSeriesId();
        String other$seriesId = other.getSeriesId();
        if (this$seriesId == null ? other$seriesId != null : !this$seriesId.equals(other$seriesId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        CampaignDataRequest this$campaignData = this.getCampaignData();
        CampaignDataRequest other$campaignData = other.getCampaignData();
        if (this$campaignData == null ? other$campaignData != null : !this$campaignData.equals(other$campaignData)) {
            return false;
        }
        LocalDateTime this$scheduledAt = this.getScheduledAt();
        LocalDateTime other$scheduledAt = other.getScheduledAt();
        if (this$scheduledAt == null ? other$scheduledAt != null : !((Object)this$scheduledAt).equals(other$scheduledAt)) {
            return false;
        }
        String this$campaignHeaderId = this.getCampaignHeaderId();
        String other$campaignHeaderId = other.getCampaignHeaderId();
        if (this$campaignHeaderId == null ? other$campaignHeaderId != null : !this$campaignHeaderId.equals(other$campaignHeaderId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$processedAt = this.getProcessedAt();
        LocalDateTime other$processedAt = other.getProcessedAt();
        if (this$processedAt == null ? other$processedAt != null : !((Object)this$processedAt).equals(other$processedAt)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$recurrenceType = this.getRecurrenceType();
        String other$recurrenceType = other.getRecurrenceType();
        if (this$recurrenceType == null ? other$recurrenceType != null : !this$recurrenceType.equals(other$recurrenceType)) {
            return false;
        }
        LocalDateTime this$recurrenceEndDate = this.getRecurrenceEndDate();
        LocalDateTime other$recurrenceEndDate = other.getRecurrenceEndDate();
        if (this$recurrenceEndDate == null ? other$recurrenceEndDate != null : !((Object)this$recurrenceEndDate).equals(other$recurrenceEndDate)) {
            return false;
        }
        String this$seriesName = this.getSeriesName();
        String other$seriesName = other.getSeriesName();
        if (this$seriesName == null ? other$seriesName != null : !this$seriesName.equals(other$seriesName)) {
            return false;
        }
        CampaignMetaDefinition this$metaDefinition = this.getMetaDefinition();
        CampaignMetaDefinition other$metaDefinition = other.getMetaDefinition();
        return !(this$metaDefinition == null ? other$metaDefinition != null : !this$metaDefinition.equals(other$metaDefinition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScheduledCampaignModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $recurrenceInterval = this.getRecurrenceInterval();
        result = result * 59 + ($recurrenceInterval == null ? 43 : ((Object)$recurrenceInterval).hashCode());
        Integer $originalScheduledDay = this.getOriginalScheduledDay();
        result = result * 59 + ($originalScheduledDay == null ? 43 : ((Object)$originalScheduledDay).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $seriesId = this.getSeriesId();
        result = result * 59 + ($seriesId == null ? 43 : $seriesId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        CampaignDataRequest $campaignData = this.getCampaignData();
        result = result * 59 + ($campaignData == null ? 43 : $campaignData.hashCode());
        LocalDateTime $scheduledAt = this.getScheduledAt();
        result = result * 59 + ($scheduledAt == null ? 43 : ((Object)$scheduledAt).hashCode());
        String $campaignHeaderId = this.getCampaignHeaderId();
        result = result * 59 + ($campaignHeaderId == null ? 43 : $campaignHeaderId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $processedAt = this.getProcessedAt();
        result = result * 59 + ($processedAt == null ? 43 : ((Object)$processedAt).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $recurrenceType = this.getRecurrenceType();
        result = result * 59 + ($recurrenceType == null ? 43 : $recurrenceType.hashCode());
        LocalDateTime $recurrenceEndDate = this.getRecurrenceEndDate();
        result = result * 59 + ($recurrenceEndDate == null ? 43 : ((Object)$recurrenceEndDate).hashCode());
        String $seriesName = this.getSeriesName();
        result = result * 59 + ($seriesName == null ? 43 : $seriesName.hashCode());
        CampaignMetaDefinition $metaDefinition = this.getMetaDefinition();
        result = result * 59 + ($metaDefinition == null ? 43 : $metaDefinition.hashCode());
        return result;
    }

    public String toString() {
        return "ScheduledCampaignModel(id=" + this.getId() + ", seriesId=" + this.getSeriesId() + ", type=" + this.getType() + ", campaignData=" + this.getCampaignData() + ", scheduledAt=" + this.getScheduledAt() + ", campaignHeaderId=" + this.getCampaignHeaderId() + ", status=" + this.getStatus() + ", createdAt=" + this.getCreatedAt() + ", processedAt=" + this.getProcessedAt() + ", errorMessage=" + this.getErrorMessage() + ", recurrenceType=" + this.getRecurrenceType() + ", recurrenceInterval=" + this.getRecurrenceInterval() + ", recurrenceEndDate=" + this.getRecurrenceEndDate() + ", seriesName=" + this.getSeriesName() + ", originalScheduledDay=" + this.getOriginalScheduledDay() + ", metaDefinition=" + this.getMetaDefinition() + ")";
    }

    public ScheduledCampaignModel() {
    }

    public ScheduledCampaignModel(String id, String seriesId, String type, CampaignDataRequest campaignData, LocalDateTime scheduledAt, String campaignHeaderId, String status, LocalDateTime createdAt, LocalDateTime processedAt, String errorMessage, String recurrenceType, Integer recurrenceInterval, LocalDateTime recurrenceEndDate, String seriesName, Integer originalScheduledDay, CampaignMetaDefinition metaDefinition) {
        this.id = id;
        this.seriesId = seriesId;
        this.type = type;
        this.campaignData = campaignData;
        this.scheduledAt = scheduledAt;
        this.campaignHeaderId = campaignHeaderId;
        this.status = status;
        this.createdAt = createdAt;
        this.processedAt = processedAt;
        this.errorMessage = errorMessage;
        this.recurrenceType = recurrenceType;
        this.recurrenceInterval = recurrenceInterval;
        this.recurrenceEndDate = recurrenceEndDate;
        this.seriesName = seriesName;
        this.originalScheduledDay = originalScheduledDay;
        this.metaDefinition = metaDefinition;
    }
}

