/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.controller;

import com.whatsapp.campaign.data.AutomationCampaign.ACUpdate.ACUpdateScheduledCampaignRequest;
import com.whatsapp.campaign.data.ScheduledCampaignRequest;
import com.whatsapp.campaign.documents.ScheduledCampaignModel;
import com.whatsapp.campaign.dto.scheduled.PagedScheduledCampaignResponseDTO;
import com.whatsapp.campaign.dto.scheduled.ScheduledCampaignResponseDTO;
import com.whatsapp.campaign.dto.scheduled.ScheduledCampaignStatsDTO;
import com.whatsapp.campaign.service.ScheduledCampaignService;
import java.time.LocalDateTime;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api"})
public class ScheduledCampaignController {
    private static final Logger log = LoggerFactory.getLogger(ScheduledCampaignController.class);
    private final ScheduledCampaignService scheduledCampaignService;

    @PostMapping(value={"/send-template-batch-scheduled"})
    public Mono<ResponseEntity<ScheduledCampaignResponseDTO>> sendTemplateBatchScheduled(@RequestBody ScheduledCampaignRequest request) {
        log.info("Crear programador: {}", (Object)request);
        log.info("Recibida solicitud para programar lote de plantillas para: {}", (Object)request.getScheduledAt());
        return this.scheduledCampaignService.scheduleCampaign(request).map(ResponseEntity::ok);
    }

    @GetMapping(value={"/scheduled-campaigns/{id}/stats"})
    public Mono<ResponseEntity<ScheduledCampaignStatsDTO>> getCampaignStats(@PathVariable String id) {
        return this.scheduledCampaignService.getCampaignStats(id).map(ResponseEntity::ok).onErrorResume(e -> {
            log.error("Error obteniendo estad\u00edsticas de campa\u00f1a {}", (Object)id, e);
            return Mono.just((Object)ResponseEntity.badRequest().build());
        });
    }

    @GetMapping(value={"/scheduled-campaigns/grouped"})
    public Mono<ResponseEntity<PagedScheduledCampaignResponseDTO<ScheduledCampaignResponseDTO>>> getGroupedCampaigns(@RequestParam(required=false) String startDate, @RequestParam(required=false) String endDate, @RequestParam(required=false) String seriesName, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size) {
        LocalDateTime start = startDate != null ? LocalDateTime.parse(startDate) : LocalDateTime.MIN;
        LocalDateTime end = endDate != null ? LocalDateTime.parse(endDate) : LocalDateTime.MAX;
        return this.scheduledCampaignService.getGroupedCampaigns(start, end, seriesName, page, size).map(ResponseEntity::ok);
    }

    @GetMapping(value={"/scheduled-campaigns/{id}/detail"})
    public Mono<ResponseEntity<Map<String, Object>>> getCampaignDetail(@PathVariable String id, @RequestParam(required=false) String conversationId, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size) {
        return this.scheduledCampaignService.getCampaignDetail(id, conversationId, page, size).map(ResponseEntity::ok);
    }

    @GetMapping(value={"/scheduled-campaigns/recurring-stats"})
    public Flux<ScheduledCampaignResponseDTO> getRecurringCampaignsStats(@RequestParam(required=false) String startDate, @RequestParam(required=false) String endDate) {
        LocalDateTime start = startDate != null ? LocalDateTime.parse(startDate) : LocalDateTime.MIN;
        LocalDateTime end = endDate != null ? LocalDateTime.parse(endDate) : LocalDateTime.MAX;
        return this.scheduledCampaignService.getRecurringCampaignsStats(start, end);
    }

    @PutMapping(value={"/scheduled-campaigns/{id}"})
    public Mono<ResponseEntity<ScheduledCampaignModel>> updateCampaign(@PathVariable String id, @RequestBody ACUpdateScheduledCampaignRequest request) {
        return this.scheduledCampaignService.updateScheduledCampaign(id, request).map(ResponseEntity::ok);
    }

    @PatchMapping(value={"/scheduled-campaigns/{id}/status"})
    public Mono<ResponseEntity<Map<String, String>>> updateStatus(@PathVariable String id, @RequestParam String status) {
        return this.scheduledCampaignService.updateStatus(id, status).map(campaign -> {
            Map<String, String> response = Map.of("id", campaign.getId(), "seriesId", campaign.getSeriesId(), "status", campaign.getStatus());
            return ResponseEntity.ok(response);
        });
    }

    @GetMapping(value={"/scheduled-campaigns/series/{seriesId}/history"})
    public Mono<ResponseEntity<PagedScheduledCampaignResponseDTO<ScheduledCampaignResponseDTO>>> getSeriesHistory(@PathVariable String seriesId, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size) {
        return this.scheduledCampaignService.getSeriesHistory(seriesId, page, size).map(ResponseEntity::ok);
    }

    @GetMapping(value={"/scheduled-campaigns/series/{seriesId}/editable"})
    public Mono<ResponseEntity<ScheduledCampaignModel>> getEditableCampaign(@PathVariable String seriesId) {
        return this.scheduledCampaignService.getEditableCampaignBySeriesId(seriesId).map(ResponseEntity::ok);
    }

    public ScheduledCampaignController(ScheduledCampaignService scheduledCampaignService) {
        this.scheduledCampaignService = scheduledCampaignService;
    }
}

