/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.controller;

import com.whatsapp.campaign.data.CampaignExportForm;
import com.whatsapp.campaign.data.CampaignSearchByConversationRequest;
import com.whatsapp.campaign.data.CampaignSearchMessageRequest;
import com.whatsapp.campaign.data.CampaignSearchRequest;
import com.whatsapp.campaign.data.PagedResponse;
import com.whatsapp.campaign.documents.CampaignModel;
import com.whatsapp.campaign.documents.CampaignModelHeader;
import com.whatsapp.campaign.dto.ErrorCampaignDetail;
import com.whatsapp.campaign.dto.ReportCampaignStatuses;
import com.whatsapp.campaign.dto.request.DateRequests;
import com.whatsapp.campaign.service.CampaignService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"campaign-report"})
public class CampaignController {
    private static final Logger log = LoggerFactory.getLogger(CampaignController.class);
    private final CampaignService service;

    @PostMapping(value={"/validate-numbers"})
    public Mono<List<ErrorCampaignDetail>> filterNumbersWithError(@RequestBody List<String> conversationIds) {
        log.info("Filtering numbers with errors for conversation IDs: {}", conversationIds);
        return this.service.filterNumbersWithError(conversationIds);
    }

    @PostMapping(value={"/statuses"}, consumes={"application/x-www-form-urlencoded"})
    public Mono<List<ReportCampaignStatuses>> getCampaignStatics(@ModelAttribute DateRequests request) {
        return this.service.obtenerListaEstadisticasPorEstadoCampana(request);
    }

    @PostMapping(value={"/templates"}, consumes={"application/x-www-form-urlencoded"})
    public Mono<PagedResponse<CampaignModelHeader>> getCampaignHeaders(@ModelAttribute CampaignSearchRequest request) {
        return this.service.getCampaignHeaders(request);
    }

    @PostMapping(value={"/by-messages"}, consumes={"application/x-www-form-urlencoded"})
    public Mono<PagedResponse<CampaignModel>> findByCampaignHeaderId(@ModelAttribute CampaignSearchMessageRequest request) {
        return this.service.findByCampaignHeaderId(request);
    }

    @PostMapping(value={"/by-conversation"}, consumes={"application/x-www-form-urlencoded"})
    public Mono<PagedResponse<CampaignModelHeader>> getCampaignsByConversation(@ModelAttribute CampaignSearchByConversationRequest request) {
        return this.service.getCampaignsByConversation(request);
    }

    @PostMapping(value={"/export-campaigns"}, consumes={"application/x-www-form-urlencoded"})
    public Mono<Void> exportCampaigns(@ModelAttribute CampaignExportForm form, ServerHttpResponse response) {
        return this.service.exportCampaigns(form, response);
    }

    public CampaignController(CampaignService service) {
        this.service = service;
    }
}

