/*
 * Decompiled with CFR 0.152.
 */
package com.gateway.interceptors;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.gateway.utils.ApiResponse;
import java.io.IOException;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class CustomAuthenticationEntryPoint
implements ServerAuthenticationEntryPoint {
    private static final Logger log = LoggerFactory.getLogger(CustomAuthenticationEntryPoint.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Mono<Void> commence(ServerWebExchange exchange, AuthenticationException authException) {
        String path = exchange.getRequest().getURI().getPath();
        String method = exchange.getRequest().getMethod().toString();
        log.error("\ud83d\udeab CustomAuthenticationEntryPoint - {} {}", (Object)method, (Object)path);
        log.error("   Exception: {}", (Object)authException.getMessage());
        if (path.startsWith("/gt-pocs/eureka-console/") || path.startsWith("/gt-pocs/eureka/")) {
            log.info("   \ud83d\udd10 Solicitando HTTP Basic Auth para Eureka");
            exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED);
            exchange.getResponse().getHeaders().set("WWW-Authenticate", "Basic realm=\"Gateway - Eureka Access\"");
            return exchange.getResponse().setComplete();
        }
        log.info("   \ud83d\udcc4 Retornando respuesta JSON");
        exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        exchange.getResponse().getHeaders().setContentType(MediaType.APPLICATION_JSON);
        String mensaje = "No autorizado";
        if (authException.getMessage() != null) {
            String errorMsg = authException.getMessage().toLowerCase();
            if (errorMsg.contains("jwt expired") || errorMsg.contains("token expired")) {
                mensaje = "Token caducado";
            } else if (errorMsg.contains("api key")) {
                mensaje = "API Key inv\u00e1lida o ausente";
            } else if (errorMsg.contains("invalid token") || errorMsg.contains("malformed")) {
                mensaje = "Token inv\u00e1lido";
            }
        }
        ApiResponse apiResponse = ApiResponse.error((int)HttpStatus.UNAUTHORIZED.value(), (String)mensaje);
        return exchange.getResponse().writeWith((Publisher)Mono.fromSupplier(() -> {
            try {
                byte[] bytes = this.objectMapper.writeValueAsBytes((Object)apiResponse);
                return exchange.getResponse().bufferFactory().wrap(bytes);
            }
            catch (IOException e) {
                log.error("Error al serializar respuesta de error", (Throwable)e);
                return exchange.getResponse().bufferFactory().wrap(new byte[0]);
            }
        }));
    }
}

