/*
 * Decompiled with CFR 0.152.
 */
package com.gateway.auth;

import com.gateway.auth.EurekaAuthenticationFilter;
import com.gateway.auth.RealmValidationFilter;
import com.gateway.interceptors.CustomAccessDeniedHandler;
import com.gateway.interceptors.CustomAuthenticationEntryPoint;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.userdetails.MapReactiveUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.server.WebFilter;
import reactor.util.context.ContextView;

@Configuration
@EnableWebFluxSecurity
public class WebSecurityConfig {
    private static final Logger log = LoggerFactory.getLogger(WebSecurityConfig.class);
    private final CustomAuthenticationEntryPoint customAuthenticationEntryPoint;
    private final CustomAccessDeniedHandler customAccessDeniedHandler;
    private final Environment env;
    private final RealmValidationFilter realmValidationFilter;
    private final EurekaAuthenticationFilter eurekaAuthenticationFilter;
    private final CorsConfigurationSource corsConfigurationSource;

    public WebSecurityConfig(CustomAuthenticationEntryPoint customAuthenticationEntryPoint, CustomAccessDeniedHandler customAccessDeniedHandler, Environment environment, RealmValidationFilter realmValidationFilter, EurekaAuthenticationFilter eurekaAuthenticationFilter, CorsConfigurationSource corsConfigurationSource) {
        this.customAuthenticationEntryPoint = customAuthenticationEntryPoint;
        this.customAccessDeniedHandler = customAccessDeniedHandler;
        this.env = environment;
        this.realmValidationFilter = realmValidationFilter;
        this.eurekaAuthenticationFilter = eurekaAuthenticationFilter;
        this.corsConfigurationSource = corsConfigurationSource;
        log.info("\ud83d\udd27 WebSecurityConfig INICIALIZADO");
    }

    @Bean
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) {
        log.info("\ud83d\udd10 Configurando SecurityWebFilterChain");
        return http.cors(cors -> cors.configurationSource(this.corsConfigurationSource)).exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((ServerAuthenticationEntryPoint)this.customAuthenticationEntryPoint).accessDeniedHandler((ServerAccessDeniedHandler)this.customAccessDeniedHandler)).authorizeExchange(authorize -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorize.pathMatchers(new String[]{"/gt-pocs/actuator/info"})).permitAll().pathMatchers(new String[]{"/gt-pocs/actuator/health"})).permitAll().pathMatchers(new String[]{"/gt-pocs/agent/webhook/tsa"})).permitAll().pathMatchers(new String[]{"/gt-pocs/agent/webhook/tsa/test/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/agent/webhook/tsa/sendMessage/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/agent/webhook/tsa/conversationStatusChanged"})).permitAll().pathMatchers(new String[]{"/gt-pocs/agent/file/download/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/agent/report-interactions/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/agent/interactions/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/agent/reports/daily-conversations/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/agent/reports/daily-conversations-labels/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/agent/list"})).permitAll().pathMatchers(HttpMethod.OPTIONS, new String[]{"/gt-pocs/campaign/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/campaign/api/username"})).permitAll().pathMatchers(new String[]{"/gt-pocs/whatsapp/webhook"})).permitAll().pathMatchers(new String[]{"/gt-pocs/whatsapp/webhook/tsa/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/whatsapp/api/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/whatsapp/lhia/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/whatsapp/state/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/whatsapp/history-conversation/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/whatsapp/imagen-url/**"})).permitAll().pathMatchers(HttpMethod.OPTIONS, new String[]{"/gt-pocs/campaign-main/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/campaign-main/instance/notify-registration"})).permitAll().pathMatchers(new String[]{"/gt-pocs/campaign-co1/webhook/**"})).permitAll().pathMatchers(HttpMethod.OPTIONS, new String[]{"/gt-pocs/campaign-co1/**"})).permitAll().pathMatchers(new String[]{"/gt-pocs/agent/api/ms/**"})).authenticated().pathMatchers(new String[]{"/gt-pocs/campaign/ms/**"})).authenticated().pathMatchers(new String[]{"/gt-pocs/whatsapp/**"})).authenticated().pathMatchers(new String[]{"/gt-pocs/eureka-console/**"})).hasRole("GATEWAY_ADMIN").pathMatchers(new String[]{"/gt-pocs/eureka/**"})).hasRole("GATEWAY_ADMIN").anyExchange().authenticated()).httpBasic(httpBasic -> {}).csrf(ServerHttpSecurity.CsrfSpec::disable).addFilterAt((WebFilter)this.eurekaAuthenticationFilter, SecurityWebFiltersOrder.AUTHENTICATION).addFilterAfter(this.apiKeyAuthenticationFilter(), SecurityWebFiltersOrder.AUTHENTICATION).addFilterAfter((WebFilter)this.realmValidationFilter, SecurityWebFiltersOrder.AUTHENTICATION).build();
    }

    private WebFilter apiKeyAuthenticationFilter() {
        return (exchange, chain) -> {
            String path = exchange.getRequest().getURI().getPath();
            log.debug("\ud83d\udd11 API Key Filter - Path: {}", (Object)path);
            if (path.startsWith("/gt-pocs/eureka-console/") || path.startsWith("/gt-pocs/eureka/")) {
                log.debug("   \u23ed\ufe0f Eureka - saltando API Key filter");
                return chain.filter(exchange);
            }
            String expectedApiKey = null;
            if (path.startsWith("/gt-pocs/agent/api/ms/")) {
                expectedApiKey = this.env.getProperty("api.key.agent");
                log.debug("   \ud83d\udd0d Validando API Key para AGENT");
            } else if (path.startsWith("/gt-pocs/campaign/ms/")) {
                expectedApiKey = this.env.getProperty("api.key.campaign");
                log.debug("   \ud83d\udd0d Validando API Key para CAMPAIGN");
            } else if (path.startsWith("/gt-pocs/whatsapp/")) {
                boolean isPublicRoute;
                boolean bl = isPublicRoute = path.equals("/gt-pocs/whatsapp/webhook") || path.startsWith("/gt-pocs/whatsapp/webhook/tsa/") || path.startsWith("/gt-pocs/whatsapp/api/") || path.startsWith("/gt-pocs/whatsapp/lhia/") || path.startsWith("/gt-pocs/whatsapp/state/") || path.startsWith("/gt-pocs/whatsapp/history-conversation/") || path.startsWith("/gt-pocs/whatsapp/imagen-url/");
                if (!isPublicRoute) {
                    expectedApiKey = this.env.getProperty("api.key.whatsapp");
                    log.debug("   \ud83d\udd0d Validando API Key para WHATSAPP");
                } else {
                    log.debug("   \u23ed\ufe0f Ruta p\u00fablica de WhatsApp - no requiere API Key");
                }
            }
            if (expectedApiKey != null) {
                String apiKeyHeader = this.env.getProperty("api.key.header", "X-API-KEY");
                String apiKey = exchange.getRequest().getHeaders().getFirst(apiKeyHeader);
                if (expectedApiKey.equals(apiKey)) {
                    log.info("   \u2705 API Key v\u00e1lida");
                    UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"apiKeyUser", null, List.of());
                    return chain.filter(exchange).contextWrite((ContextView)ReactiveSecurityContextHolder.withAuthentication((Authentication)auth));
                }
                log.error("   \u274c API Key inv\u00e1lida o ausente");
                return this.customAuthenticationEntryPoint.commence(exchange, (AuthenticationException)new /* Unavailable Anonymous Inner Class!! */);
            }
            log.debug("   \u23ed\ufe0f No requiere API Key");
            return chain.filter(exchange);
        };
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public MapReactiveUserDetailsService userDetailsService(PasswordEncoder passwordEncoder) {
        String gatewayUsername = this.env.getProperty("gateway.admin.username", "wily-admin-gateway");
        String gatewayPassword = this.env.getProperty("gateway.admin.password", "7bb01cd1c40e49ab14ca47db309a2");
        log.info("\ud83d\udd10 Configurando usuario admin para Gateway: {}", (Object)gatewayUsername);
        UserDetails gatewayAdmin = User.builder().username(gatewayUsername).password(passwordEncoder.encode((CharSequence)gatewayPassword)).roles(new String[]{"GATEWAY_ADMIN"}).build();
        return new MapReactiveUserDetailsService(new UserDetails[]{gatewayAdmin});
    }
}

