/*
 * Decompiled with CFR 0.152.
 */
package com.gateway.auth;

import com.gateway.auth.JwtAuthConverter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

@Component
public class RealmValidationFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger(RealmValidationFilter.class);
    private final Map<String, ReactiveJwtDecoder> decoders = new HashMap();
    private final JwtAuthConverter jwtAuthConverter;

    public RealmValidationFilter(JwtAuthConverter jwtAuthConverter) {
        this.jwtAuthConverter = jwtAuthConverter;
        log.info("\ud83d\ude80 RealmValidationFilter INICIALIZADO");
        this.decoders.put("meta_pocs", NimbusReactiveJwtDecoder.withIssuerLocation((String)"https://login.tws2.io/auth/realms/meta_pocs").build());
        this.decoders.put("lhia", NimbusReactiveJwtDecoder.withIssuerLocation((String)"https://login.tws2.io/auth/realms/lhia").build());
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String path = exchange.getRequest().getURI().getPath();
        String authHeader = exchange.getRequest().getHeaders().getFirst("Authorization");
        log.info("\ud83d\udd0d RealmValidationFilter - Path: {}", (Object)path);
        if (path.startsWith("/gt-pocs/eureka-console/") || path.startsWith("/gt-pocs/eureka/")) {
            log.info("   \u23ed\ufe0f Eureka - saltando validaci\u00f3n de realm");
            return chain.filter(exchange);
        }
        if (authHeader != null && authHeader.startsWith("Bearer ")) {
            String token = authHeader.substring(7);
            String requiredRealm = this.getRequiredRealm(path);
            log.info("   \ud83c\udff0 Validando realm: {}", (Object)requiredRealm);
            ReactiveJwtDecoder decoder = (ReactiveJwtDecoder)this.decoders.get(requiredRealm);
            if (decoder == null) {
                log.error("   \u274c No existe decoder para realm: {}", (Object)requiredRealm);
                exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                return exchange.getResponse().setComplete();
            }
            return decoder.decode(token).flatMap(jwt -> {
                String issuer = jwt.getIssuer() != null ? jwt.getIssuer().toString() : "";
                log.info("   \u2705 Token v\u00e1lido - Issuer: {}", (Object)issuer);
                if (!issuer.contains(requiredRealm)) {
                    log.error("   \u274c Realm incorrecto. Esperado: {}, Recibido: {}", (Object)requiredRealm, (Object)issuer);
                    exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.FORBIDDEN);
                    return exchange.getResponse().setComplete();
                }
                return this.jwtAuthConverter.convert(jwt).flatMap(auth -> chain.filter(exchange).contextWrite((ContextView)ReactiveSecurityContextHolder.withAuthentication((Authentication)auth))).switchIfEmpty(Mono.defer(() -> {
                    log.info("   \u26a0\ufe0f JwtAuthConverter retorn\u00f3 vac\u00edo");
                    exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED);
                    return exchange.getResponse().setComplete();
                }));
            }).onErrorResume(e -> {
                log.error("   \u274c Error al decodificar JWT: {}", (Object)e.getMessage());
                exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED);
                return exchange.getResponse().setComplete();
            });
        }
        log.info("   \u23ed\ufe0f Sin token JWT Bearer - pasando al siguiente filtro");
        return chain.filter(exchange);
    }

    private String getRequiredRealm(String path) {
        if (path.startsWith("/gt-pocs/campaign/") || path.startsWith("/gt-pocs/campaign-co1/") || path.startsWith("/gt-pocs/campaign-main/") || path.startsWith("/gt-pocs/whatsapp/")) {
            return "lhia";
        }
        return "meta_pocs";
    }
}

