/*
 * Decompiled with CFR 0.152.
 */
package com.gateway.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
public class EurekaAuthenticationFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger(EurekaAuthenticationFilter.class);
    private final Environment env;
    private final String eurekaBasicAuth;

    public EurekaAuthenticationFilter(Environment env) {
        this.env = env;
        String eurekaUsername = env.getProperty("eureka.username", "wily-pocs");
        String eurekaPassword = env.getProperty("eureka.password", "iFEwzfWty0C4czu673cLD8u1HlibBJg4QWaqraAc9UceWii1sGCjPj2isW6gDSEd");
        String credentials = eurekaUsername + ":" + eurekaPassword;
        this.eurekaBasicAuth = "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
        log.info("\ud83d\udd10 EurekaAuthenticationFilter INICIALIZADO");
        log.info("   Eureka Username: {}", (Object)eurekaUsername);
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String path = exchange.getRequest().getURI().getPath();
        if (path.startsWith("/gt-pocs/eureka-console/") || path.startsWith("/gt-pocs/eureka/")) {
            log.debug("\ud83d\udd11 Verificando autenticaci\u00f3n para Eureka path: {}", (Object)path);
            return ReactiveSecurityContextHolder.getContext().flatMap(securityContext -> {
                if (securityContext.getAuthentication() != null && securityContext.getAuthentication().isAuthenticated()) {
                    log.debug("   \u2705 Usuario autenticado, inyectando credenciales de Eureka");
                    ServerWebExchange modifiedExchange = exchange.mutate().request(r -> r.headers(headers -> {
                        headers.remove((Object)"Authorization");
                        headers.set("Authorization", this.eurekaBasicAuth);
                    })).build();
                    return chain.filter(modifiedExchange);
                }
                log.debug("   \u23ed\ufe0f Usuario no autenticado, continuando sin modificar");
                return chain.filter(exchange);
            }).switchIfEmpty(Mono.defer(() -> {
                log.debug("   \u23ed\ufe0f No hay contexto de seguridad, continuando sin modificar");
                return chain.filter(exchange);
            }));
        }
        return chain.filter(exchange);
    }
}

