/*
 * Decompiled with CFR 0.152.
 */
package com.agent.utils;

import com.agent.tsa.DTO.ConversationsCountDTO;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FechaUtils {
    private static final DateTimeFormatter FORMATO = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static LocalDateTime convertirALocalDateTimeEcuador(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        ZonedDateTime utcZoned = localDateTime.atZone(ZoneOffset.UTC);
        ZonedDateTime ecuadorZoned = utcZoned.withZoneSameInstant(ZoneId.of("America/Guayaquil"));
        return ecuadorZoned.toLocalDateTime();
    }

    public static LocalDateTime convertirAFecha(String fechaTexto) {
        if (fechaTexto == null || fechaTexto.isBlank()) {
            throw new IllegalArgumentException("La fecha no puede ser nula o vac\u00eda");
        }
        return LocalDateTime.parse(fechaTexto, FORMATO);
    }

    public static List<ConversationsCountDTO> completarDiasFaltantes(List<ConversationsCountDTO> resultados, LocalDate inicio, LocalDate fin) {
        Map<LocalDate, Long> map = resultados.stream().collect(Collectors.toMap(ConversationsCountDTO::getDate, ConversationsCountDTO::getTotal));
        ArrayList<ConversationsCountDTO> resultadoCompleto = new ArrayList<ConversationsCountDTO>();
        LocalDate actual = inicio;
        while (!actual.isAfter(fin)) {
            long total = map.getOrDefault(actual, 0L);
            resultadoCompleto.add(new ConversationsCountDTO(Long.valueOf(total), actual));
            actual = actual.plusDays(1L);
        }
        return resultadoCompleto;
    }
}

