/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.client.external.service.SendMessagesToApiService;
import com.agent.tsa.data.RequestMessageModel;
import com.agent.tsa.data.conversation.Conversation;
import com.agent.tsa.data.conversation.Meta;
import com.agent.tsa.data.conversation.messages.MessageDetails;
import com.agent.tsa.data.sender.Sender;
import com.agent.tsa.events.ContactEvent;
import com.agent.tsa.events.ConversationEvent;
import com.agent.tsa.events.MessageEvent;
import com.agent.tsa.models.conversation.ConversationAdditionalAttributes;
import com.agent.tsa.service.ContactService;
import com.agent.tsa.service.ConversationService;
import com.agent.tsa.service.MessageService;
import com.agent.tsa.service.ThinkAgentService;
import com.agent.tsa.utils.StatusUtil;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ThinkAgentServiceImpl
implements ThinkAgentService {
    private static final Logger log = LoggerFactory.getLogger(ThinkAgentServiceImpl.class);
    private final ObjectMapper objectMapper;
    private final ContactService contactService;
    private final ConversationService conversationService;
    private final MessageService messageService;
    private final SendMessagesToApiService sendMessagesToApiService;

    public Mono<ResponseEntity<String>> processWebhookFromTAS(Object event) {
        log.info("PROCESANDO EL CALLBACK DE TAS");
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        String jsonString = "";
        try {
            if (event instanceof Map) {
                Map eventMap = (Map)event;
                String eventType = (String)eventMap.get("event");
                log.warn("EVENT TYPE {}", (Object)eventType);
                switch (eventType) {
                    case "contact_updated": {
                        ContactEvent contactEvent = (ContactEvent)this.objectMapper.convertValue((Object)eventMap, ContactEvent.class);
                        return this.contactService.saveOrUpdateContact(contactEvent, eventType).then(Mono.just((Object)ResponseEntity.ok().build()));
                    }
                    case "conversation_created": 
                    case "conversation_updated": {
                        jsonString = this.objectMapper.writeValueAsString((Object)eventMap);
                        ConversationEvent conversationEvent = (ConversationEvent)this.objectMapper.readValue(jsonString, ConversationEvent.class);
                        return this.conversationService.saveOrUpdateConversation(conversationEvent, eventType).flatMap(conversation -> {
                            if (conversationEvent.getStatus().equals(StatusUtil.ST_CONVERSATION_RESOLVED)) {
                                log.info("CONVERSATION RESOLVED, SENDING CLOSED NOTIFICATION TO WHATSAPP");
                                Meta meta = conversationEvent.getMeta();
                                if (meta != null && meta.getSender() != null) {
                                    Sender sender = meta.getSender();
                                    String identifier = sender.getIdentifier();
                                    String nickName = sender.getName();
                                    String accountId = conversation.getAccountId();
                                    String conversationId = String.valueOf(conversation.getConversationId());
                                    String callbackUrlFromEvent = conversationEvent.getAdditionalAttributes() != null ? conversationEvent.getAdditionalAttributes().getCallbackUrl() : null;
                                    Mono getCallbackUrl = callbackUrlFromEvent != null ? Mono.just((Object)callbackUrlFromEvent) : this.conversationService.findCallbackUrlFromConversationIdAndAccountId(conversationId, accountId);
                                    return getCallbackUrl.flatMap(callbackUrl -> {
                                        RequestMessageModel messageModel = RequestMessageModel.createTemplateMessage((String)identifier, null, null, (String)"message", (String)"text", (String)"CONVERSACION_CERRADA", (String)nickName, (String)"");
                                        return this.sendMessagesToApiService.sendMessageToWebhook(messageModel, callbackUrl).doOnSuccess(ignore -> log.info("CLOSED NOTIFICATION SENT")).doOnError(e -> log.error("ERROR SENDING CLOSED NOTIFICATION", e));
                                    }).then(Mono.just((Object)ResponseEntity.ok().build()));
                                }
                            }
                            return Mono.just((Object)ResponseEntity.ok().build());
                        });
                    }
                    case "message_updated": 
                    case "message_created": {
                        MessageDetails firstMessage;
                        jsonString = this.objectMapper.writeValueAsString((Object)eventMap);
                        MessageEvent messageEvent = (MessageEvent)this.objectMapper.readValue(jsonString, MessageEvent.class);
                        String messageType = messageEvent.getMessageType();
                        Boolean isPrivate = messageEvent.getPrivateMessage();
                        Conversation conversation2 = messageEvent.getConversation();
                        ConversationAdditionalAttributes additionalAttributes = conversation2.getAdditionalAttributes();
                        String contentType = messageEvent.getContentType();
                        if (isPrivate.booleanValue() || messageType.equalsIgnoreCase("incoming") || messageType.equals("template") && eventType.equals("message_updated")) {
                            return Mono.just((Object)ResponseEntity.ok((Object)"OK"));
                        }
                        if (additionalAttributes != null && (firstMessage = (MessageDetails)conversation2.getMessages().stream().findFirst().orElse(null)) != null) {
                            long timeDiff = Math.abs((long)firstMessage.getCreatedAt().intValue() - conversation2.getCreatedAt());
                            if (additionalAttributes.getIgnoreInitMessage() != null && additionalAttributes.getIgnoreInitMessage().booleanValue() && messageType.equals("template") && conversation2.getFirstReplyCreatedAt() == null && contentType.equals("text") && timeDiff <= 5L) {
                                log.info("IGNORANDO MENSAJE DE INICIO DE CONVERSACION");
                                return Mono.just((Object)ResponseEntity.ok((Object)"OK"));
                            }
                        }
                        return this.messageService.sendMessagesToAPI(messageEvent);
                    }
                }
                log.warn("IGNORANDO EVENTO TIPO: {}", (Object)eventType);
                return Mono.just((Object)ResponseEntity.badRequest().body((Object)"Unknown event type"));
            }
            System.out.println("no es una isntancia de map");
            return Mono.just((Object)ResponseEntity.ok().build());
        }
        catch (Exception e) {
            log.error("EL BODY NO CORRESPONDE AL FORMATO CORRECTO {}", (Throwable)e);
            return Mono.just((Object)ResponseEntity.badRequest().body((Object)"Error"));
        }
    }

    public Mono<ResponseEntity<String>> processMessageFromWebhook(MessageEvent messageEvent) {
        String eventType = messageEvent.getEvent();
        String messageType = messageEvent.getMessageType();
        Boolean isPrivate = messageEvent.getPrivateMessage();
        if (isPrivate.booleanValue() || messageType.equalsIgnoreCase("incoming") || messageType.equals("template") && eventType.equals("message_updated")) {
            return Mono.just((Object)ResponseEntity.ok((Object)"OK"));
        }
        return this.messageService.sendMessagesToAPI(messageEvent);
    }

    public ThinkAgentServiceImpl(ObjectMapper objectMapper, ContactService contactService, ConversationService conversationService, MessageService messageService, SendMessagesToApiService sendMessagesToApiService) {
        this.objectMapper = objectMapper;
        this.contactService = contactService;
        this.conversationService = conversationService;
        this.messageService = messageService;
        this.sendMessagesToApiService = sendMessagesToApiService;
    }
}

