/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.cache.TeamCacheService;
import com.agent.tsa.repository.TeamDAO;
import com.agent.tsa.service.TeamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class TeamServiceImpl
implements TeamService {
    private static final Logger log = LoggerFactory.getLogger(TeamServiceImpl.class);
    private final TeamDAO teamDAO;
    private final TeamCacheService teamCacheService;

    public Mono<String> findAccountIdByInboxId(String inboxId) {
        return this.teamCacheService.getAccountIdByInboxId(inboxId).switchIfEmpty(this.teamDAO.findAccountIdByInboxId(inboxId).flatMap(accountId -> this.teamCacheService.setAccountIdByInboxId(inboxId, accountId).thenReturn(accountId)));
    }

    public Mono<String> findCallbackUrlFromTeamIdAndAccountId(String teamId, String accountId) {
        return this.teamCacheService.getCallbackUrlByTeamIdAndAccountId(teamId, accountId).switchIfEmpty(this.teamDAO.findCallbackUrlFromTeamdAndAccountId(Long.valueOf(Long.parseLong(teamId)), accountId).flatMap(url -> this.teamCacheService.setCallbackUrlByTeamIdAndAccountId(teamId, accountId, url).thenReturn(url)));
    }

    public Mono<String> findInboxIdByCallback(String callback) {
        return this.teamCacheService.getInboxIdByCallbackId(callback).switchIfEmpty(this.teamDAO.findByInboxIdByCallback(callback).flatMap(inboxId -> this.teamCacheService.setInboxIdByCallbackId(callback, inboxId).thenReturn(inboxId)));
    }

    public Mono<Long> findTeamIdByCallback(String callback) {
        return this.teamCacheService.getTeamIdByCallbackId(callback).map(Long::parseLong).switchIfEmpty(this.teamDAO.findIdByCallback(callback).flatMap(teamId -> this.teamCacheService.setTeamIdByCallbackId(callback, String.valueOf(teamId)).thenReturn(teamId)));
    }

    public Mono<String> findAccountIdByCallbackId(String callbackId) {
        return this.teamCacheService.getAccountIdByCallbackId(callbackId).switchIfEmpty(this.teamDAO.findAccountIdByCallbackId(callbackId).flatMap(accountId -> this.teamCacheService.setAccountIdByCallbackId(callbackId, accountId).thenReturn(accountId)));
    }

    public Mono<String> findAccountIdByTeamId(Long teamId) {
        return this.teamCacheService.getAccountIdByTeamId(teamId.toString()).switchIfEmpty(this.teamDAO.findAccountIdByTeamId(teamId).flatMap(accountId -> this.teamCacheService.setAccountIdByTeamId(teamId.toString(), accountId).thenReturn(accountId)));
    }

    public TeamServiceImpl(TeamDAO teamDAO, TeamCacheService teamCacheService) {
        this.teamDAO = teamDAO;
        this.teamCacheService = teamCacheService;
    }
}

