/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.tsa.DTO.ConversationLabelsCountDTO;
import com.agent.tsa.DTO.ConversationsCountDTO;
import com.agent.tsa.DTO.ObservationCountDTO;
import com.agent.tsa.repository.ConversationDAO;
import com.agent.tsa.repository.InteractionDAO;
import com.agent.tsa.service.ReportService;
import com.agent.utils.FechaUtils;
import com.agent.utils.Utils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ReportServiceImpl
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportServiceImpl.class);
    private final ConversationDAO conversationDao;
    private final InteractionDAO interactionDao;

    public Mono<List<ConversationsCountDTO>> getConversationsCount(String accountId, LocalDate initDate, LocalDate endDate) {
        log.info("getConversationsCount accountId: {}, initDate: {}, endDate: {}", new Object[]{accountId, initDate, endDate});
        String idEmpresa = Utils.getIdEmpresa((String)accountId);
        if (idEmpresa == null) {
            log.error("No se ha podido obtener el id de la empresa");
            throw new RuntimeException("No se ha podido obtener el id de la empresa");
        }
        LocalDateTime initDateLocalDateTime = initDate.atStartOfDay();
        LocalDateTime endDateLocalDateTime = endDate.atTime(23, 59, 59);
        return this.conversationDao.countConversationsByDateAndAccountId(initDateLocalDateTime, endDateLocalDateTime, idEmpresa).collectList().map(resultados -> FechaUtils.completarDiasFaltantes((List)resultados, (LocalDate)initDate, (LocalDate)endDate));
    }

    public Flux<ConversationLabelsCountDTO> getConversationLabelsCountByDateAndAccountId(String accountId, LocalDate initDate, LocalDate endDate) {
        String idEmpresa = Utils.getIdEmpresa((String)accountId);
        log.info("consultando reporte de la empresa {}", (Object)idEmpresa);
        if (idEmpresa == null) {
            log.error("No se ha podido obtener el id de la empresa");
            throw new RuntimeException("No se ha podido obtener el id de la empresa");
        }
        return this.conversationDao.findConversationLabelsCountByDateAndAccountId(initDate, endDate, idEmpresa);
    }

    public Flux<ObservationCountDTO> getConversationObservationByDateRange(LocalDate initDate, LocalDate endDate) {
        return this.interactionDao.countObservationsByDateRange(initDate, endDate);
    }

    public Mono<Integer> obtenerTokensReactive(LocalDate initDate, LocalDate endDate) {
        return this.interactionDao.countInteractionsByDateRange(initDate, endDate).map(Long::intValue).defaultIfEmpty((Object)0);
    }

    public Mono<Integer> obtenerPersonasAtendidas(LocalDate initDate, LocalDate endDate) {
        return this.interactionDao.countDistinctPhonesByDateRange(initDate, endDate).map(Long::intValue).defaultIfEmpty((Object)0);
    }

    public ReportServiceImpl(ConversationDAO conversationDao, InteractionDAO interactionDao) {
        this.conversationDao = conversationDao;
        this.interactionDao = interactionDao;
    }
}

