/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.exceptions.CustomException;
import com.agent.tsa.data.FileDownloadMeta;
import com.agent.tsa.entity.TFile;
import com.agent.tsa.repository.FileDAO;
import com.agent.tsa.service.AudioConversionService;
import com.agent.tsa.service.FileDownloadService;
import com.agent.tsa.service.FileService;
import com.agent.utils.FileUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class FileServiceImpl
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(FileServiceImpl.class);
    private final FileDAO fileDAO;
    private final FileDownloadService fileDownloadService;
    private final AudioConversionService audioConversionService;
    private final WebClient webClient;
    private final Environment env;

    public FileServiceImpl(FileDAO fileDAO, FileDownloadService fileDownloadService, AudioConversionService audioConversionService, @Qualifier(value="whatsappWebClient") WebClient webClient, Environment env, ObjectMapper objectMapper) {
        this.fileDAO = fileDAO;
        this.fileDownloadService = fileDownloadService;
        this.audioConversionService = audioConversionService;
        this.webClient = webClient;
        this.env = env;
    }

    public Mono<FileDownloadMeta> downloadFilesFromMeta(String imageUrl, String fileName, String apiToken) {
        log.info("Downloading file from {}", (Object)imageUrl);
        HttpHeaders headers = new HttpHeaders();
        if (apiToken != null) {
            headers.set("Authorization", "Bearer " + apiToken);
        }
        return this.webClient.get().uri(imageUrl, new Object[0]).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers)).retrieve().toEntity(byte[].class).flatMap(response -> {
            log.warn("headers: {}", response);
            String contentType = response.getHeaders().getContentType().toString();
            String defaultFileName = response.getHeaders().getContentDisposition().getFilename();
            String filename = this.extractFilename(contentType, defaultFileName);
            log.info("File downloaded successfully with content type {}", (Object)contentType);
            FileDownloadMeta fileContent = new FileDownloadMeta();
            fileContent.setName(filename);
            fileContent.setContentType(contentType);
            fileContent.setData((byte[])response.getBody());
            return Mono.just((Object)fileContent);
        }).doOnError(e -> log.error("Error saving File", e));
    }

    public Mono<TFile> saveNewFileAndGetId(TFile file) {
        return this.fileDAO.save((Object)file);
    }

    private Mono<Integer> insertNewFile(TFile file) {
        return this.fileDAO.insertNewFile(file.getId(), file.getName(), file.getContentType(), file.getData(), file.getCreatedAt());
    }

    public Mono<String> convertAudioFromUrl(String audioUrl) {
        String rutaTemporal = this.env.getProperty("ruta.temporal");
        if (rutaTemporal == null || rutaTemporal.isEmpty()) {
            return Mono.just(null);
        }
        String fileId = UUID.randomUUID().toString();
        return this.fileDownloadService.downloadFile(audioUrl, fileId, rutaTemporal).flatMap(rutaOga -> this.audioConversionService.convertOgaToMp3(rutaOga, fileId, rutaTemporal).flatMap(convertedFile -> {
            try {
                Path filePath = convertedFile.toPath();
                log.info("File converted: {}", (Object)filePath);
                TFile fileContent = new TFile();
                fileContent.setId(UUID.fromString(fileId));
                fileContent.setName(convertedFile.getName());
                fileContent.setContentType(Files.probeContentType(filePath));
                fileContent.setData(Files.readAllBytes(filePath));
                return this.insertNewFile(fileContent).flatMap(savedFile -> {
                    log.info("File saved with id: {}", (Object)UUID.fromString(fileId));
                    if (savedFile == 0) {
                        return Mono.error((Throwable)new CustomException("Error al guardar el archivo", HttpStatus.UNAUTHORIZED));
                    }
                    return this.deleteFileFromPath(rutaTemporal.concat(fileContent.getName())).then(this.deleteFileFromPath(rutaTemporal.concat(convertedFile.getAbsolutePath()))).then(Mono.just((Object)fileContent.getName()));
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.deleteFileFromPath(rutaTemporal.concat(convertedFile.getAbsolutePath())).then(Mono.error((Throwable)new CustomException("", HttpStatus.UNAUTHORIZED)));
            }
        })).doFinally(signalType -> System.out.println("Proceso completado con se\u00f1al: " + signalType)).onErrorResume(e -> {
            e.printStackTrace();
            return Mono.error((Throwable)new CustomException("", HttpStatus.UNAUTHORIZED));
        });
    }

    public Mono<TFile> getImage(String name) {
        return this.fileDAO.findByName(name);
    }

    private String extractFilename(String contentType, String defaultName) {
        String extension;
        log.info("Extracting filename from content type: {}, fileName: {}", (Object)contentType, (Object)defaultName);
        if (defaultName != null && !defaultName.isEmpty()) {
            log.info("Returning default name: {}", (Object)defaultName);
            return defaultName;
        }
        String uuidFileName = UUID.randomUUID().toString();
        if (contentType != null && !contentType.isEmpty() && (extension = FileUtils.getextensionFromContentType((String)contentType)) != null) {
            return uuidFileName.concat(extension);
        }
        return uuidFileName.concat(defaultName);
    }

    private Mono<Void> deleteFileFromPath(String ruta) {
        return Mono.fromRunnable(() -> {
            File file = new File(ruta);
            if (file.exists() && !file.delete()) {
                log.error("No se pudo eliminar el archivo temporal: {}", (Object)ruta);
            }
        });
    }
}

