/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.cache.ContactCacheService;
import com.agent.client.tsa.contact.models.CreateContactModel;
import com.agent.client.tsa.contact.models.CreateContactResponse;
import com.agent.client.tsa.contact.models.PayloadFindContactById;
import com.agent.client.tsa.contact.service.TsaContactApiService;
import com.agent.tsa.entity.TContact;
import com.agent.tsa.events.ContactEvent;
import com.agent.tsa.repository.ContactDAO;
import com.agent.tsa.service.ContactService;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ContactServiceImpl
implements ContactService {
    private static final Logger log = LoggerFactory.getLogger(ContactServiceImpl.class);
    private final ContactCacheService contactCacheService;
    private final ContactDAO contactDAO;
    private final TsaContactApiService tsaContactApiService;

    public Mono<Long> findIdTsaByIdentifier(String name, String identifier, String integration, String accountId) {
        return this.contactCacheService.getIdTsaByIdentifier(identifier, accountId).map(Long::parseLong).switchIfEmpty(this.contactDAO.findIdTsaByIdentifierAndAccountId(identifier, accountId).flatMap(id -> this.contactCacheService.setIdTsaByIdentifier(identifier, accountId, id).thenReturn(id)).switchIfEmpty(this.getContactTsaIdFromApi(name, identifier, integration, accountId).flatMap(id -> this.contactCacheService.setIdTsaByIdentifier(identifier, accountId, id).thenReturn(id))));
    }

    public Mono<Long> findIdContactByIdTsa(Long idTsa, String accountId) {
        return this.contactCacheService.getIdContactByIdTsa(idTsa, accountId).map(Long::parseLong).switchIfEmpty(this.contactDAO.findIdContactByIdTsaAndAccountId(idTsa, accountId).flatMap(id -> this.contactCacheService.setIdContactByIdTsa(idTsa, accountId, id).thenReturn(id)));
    }

    public Mono<TContact> saveOrUpdateContact(ContactEvent contactEvent, String event) {
        log.info("CONTACT EVENT: {}, Contact Event: {}", (Object)event, (Object)contactEvent);
        String identifier = contactEvent.getIdentifier();
        String integration = contactEvent.getCustomAttributes() != null && contactEvent.getCustomAttributes().getIntegration() != null ? contactEvent.getCustomAttributes().getIntegration() : "INTEGRATION_NOT_ALLOWED";
        log.info("Integration: {}", (Object)integration);
        return this.saveContact(String.valueOf(contactEvent.getAccount().getId()), contactEvent.getId(), contactEvent.getName(), contactEvent.getPhoneNumber(), identifier, integration);
    }

    public Mono<TContact> saveOrUpdateContactFromApiConversation(PayloadFindContactById response, String accountId) {
        log.info("CONTACT EVENT: API CONVERSATION");
        String identifier = response.getPayload().getIdentifier();
        String integration = response.getPayload().getCustomAttributes() != null && response.getPayload().getCustomAttributes().getIntegration() != null ? response.getPayload().getCustomAttributes().getIntegration() : "INTEGRATION_NOT_ALLOWED";
        return this.saveContact(accountId, response.getPayload().getId(), response.getPayload().getName(), response.getPayload().getPhoneNumber(), identifier, integration);
    }

    private Mono<TContact> saveContact(String accountId, Long idTsa, String name, String phoneNumber, String identifier, String integration) {
        String phoneNumberMod = phoneNumber == null ? null : phoneNumber.replace("+", "");
        return this.contactDAO.findByIdTsaAndAccountId(idTsa, accountId).flatMap(existingContact -> {
            existingContact.setName(name);
            existingContact.setAccountId(accountId);
            if (phoneNumberMod != null) {
                existingContact.setPhoneNumber(phoneNumberMod);
            }
            existingContact.setIntegration(integration);
            existingContact.setIdentifier(identifier);
            existingContact.setUpdatedAt(LocalDateTime.now());
            return this.contactDAO.save(existingContact);
        }).switchIfEmpty(Mono.deferContextual(ctx -> {
            TContact contact = new TContact();
            contact.setIdTsa(idTsa);
            contact.setName(name);
            contact.setAccountId(accountId);
            if (phoneNumberMod != null) {
                contact.setPhoneNumber(phoneNumberMod);
            }
            contact.setIntegration(integration);
            contact.setIdentifier(identifier);
            contact.setCreatedAt(LocalDateTime.now());
            contact.setUpdatedAt(LocalDateTime.now());
            return this.contactDAO.save((Object)contact);
        })).onErrorResume(ex -> {
            log.error("Error al actualizar el contacto: {}", (Object)ex.getMessage());
            return Mono.empty();
        });
    }

    public Mono<CreateContactResponse> createNewContactOnTSA(String name, String identifier, String integration, String accountId) {
        String phoneNumber;
        log.info("CREATING NEW CONTACT ON TSA WITH INTEGRATION: {}", (Object)integration);
        String string = phoneNumber = integration.equalsIgnoreCase("whatsapp") ? "+" + identifier : null;
        String phone = phoneNumber != null ? (!phoneNumber.startsWith("+") ? "+" + phoneNumber : phoneNumber) : null;
        CreateContactModel contactModel = CreateContactModel.builder().name(name).phone_number(phone).identifier(identifier).customAttributes(new CreateContactModel.CustomAttributes(integration)).build();
        return this.tsaContactApiService.createNewContact(contactModel, accountId).flatMap(contactResponse -> {
            log.info("CONTACT CREATED ON TSA: {}", contactResponse);
            log.info("SAVING CONTACT ON DB");
            Long contactTsaId = contactResponse.getPayload().getContact().getId();
            return this.saveContact(accountId, contactTsaId, name, phone, identifier, integration).flatMap(savedContact -> {
                log.info("CONTACT SAVED ON DB: {}", savedContact);
                return Mono.just((Object)contactResponse);
            }).onErrorResume(ex -> {
                log.error("Error al guardar el contacto en la base de datos: {}", ex);
                return Mono.just((Object)contactResponse);
            });
        });
    }

    public Mono<Long> getContactTsaIdFromApi(String name, String identifier, String integration, String accountId) {
        return this.tsaContactApiService.getContactByParam(identifier, accountId).flatMap(contactFromApi -> Mono.just((Object)contactFromApi.getId())).switchIfEmpty(this.createNewContactOnTSA(name, identifier, integration, accountId).flatMap(createdContact -> Mono.just((Object)createdContact.getPayload().getContact().getId())));
    }

    public Mono<String> findIdentifierByContactIdAndAccountId(Long contactId, String accountId) {
        return this.contactDAO.findIdentifierByContactIdAndAccountId(contactId, accountId);
    }

    public ContactServiceImpl(ContactCacheService contactCacheService, ContactDAO contactDAO, TsaContactApiService tsaContactApiService) {
        this.contactCacheService = contactCacheService;
        this.contactDAO = contactDAO;
        this.tsaContactApiService = tsaContactApiService;
    }
}

