/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.client.tsa.agent.AgentRestClientService;
import com.agent.client.tsa.agent.models.AgentModel;
import com.agent.tsa.service.AgentService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class AgentServiceImpl
implements AgentService {
    private static final Logger log = LoggerFactory.getLogger(AgentServiceImpl.class);
    private final AgentRestClientService agentRestClientService;

    public Mono<List<AgentModel>> getActiveAgents(String accountId) {
        log.info("MAKING CALL TO GET ACTIVE AGENTS");
        return this.agentRestClientService.getListAgents(accountId).map(agentList -> agentList.stream().filter(agent -> "online".equals(agent.getAvailabilityStatus())).toList()).doOnSuccess(response -> log.info("API call made successfully with response: {}", response)).onErrorResume(error -> {
            log.error("Error making API call", error);
            return Mono.just(List.of());
        });
    }

    public Mono<Boolean> isLastAgentActive(String accountId, Long agentId) {
        if (agentId == 0L) {
            return Mono.just((Object)false);
        }
        return this.getActiveAgents(accountId).map(activeAgents -> activeAgents.stream().anyMatch(agent -> agent.getId().equals(agentId.toString())));
    }

    public Mono<Long> getActiveAgentByEmail(String email, String accountId) {
        return this.getActiveAgents(accountId).map(activeAgents -> activeAgents.stream().filter(agent -> email.equalsIgnoreCase(agent.getEmail())).findFirst().map(agent -> {
            log.info("\u2705 Agente activo encontrado: id {}, email {}", (Object)agent.getId(), (Object)agent.getEmail());
            return Long.valueOf(agent.getId());
        }).orElseGet(() -> {
            log.warn("\u274c Agente activo no encontrado: email {}", (Object)email);
            return 0L;
        }));
    }

    public AgentServiceImpl(AgentRestClientService agentRestClientService) {
        this.agentRestClientService = agentRestClientService;
    }
}

