/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.repository;

import com.agent.tsa.models.Schedules.ScheduleModel;
import java.time.LocalDateTime;
import org.springframework.data.r2dbc.repository.Query;
import org.springframework.data.r2dbc.repository.R2dbcRepository;
import reactor.core.publisher.Flux;

public interface ScheduleDAO
extends R2dbcRepository<ScheduleModel, Long> {
    @Query(value="WITH date_range AS (\n        SELECT generate_series(\n            CAST(:initDate AS date),\n            CAST(:endDate AS date),\n            interval '1 day'\n        )::date AS target_date\n    ),\n    schedule_with_dates AS (\n        SELECT\n            d.target_date,\n            s.*\n        FROM date_range d\n        CROSS JOIN LATERAL (\n            SELECT DISTINCT ON (sc.account_id, sc.day_of_week)  -- \u00a1Cambio importante aqu\u00ed!\n                sc.day_of_week,\n                sc.closed_all_day,\n                sc.open_hour,\n                sc.open_minutes,\n                sc.close_hour,\n                sc.close_minutes,\n                sc.open_all_day,\n                sc.created_at,\n                sc.account_id\n            FROM service_agent.t_schedules sc\n            WHERE sc.account_id = :accountId  -- Filtro importante\n            AND sc.created_at <= d.target_date + interval '1 day' - interval '1 second'\n            ORDER BY sc.account_id, sc.day_of_week, sc.created_at DESC  -- Orden actualizado\n        ) s\n    )\n    SELECT *\n    FROM schedule_with_dates\n    WHERE account_id = :accountId\n    ORDER BY target_date, day_of_week\n")
    public Flux<ScheduleModel> getScheduleByDate(LocalDateTime var1, LocalDateTime var2, String var3);
}

