/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.events;

import com.agent.tsa.data.assignee.Assignee;
import com.agent.tsa.data.contact.ContactInbox;
import com.agent.tsa.data.conversation.Meta;
import com.agent.tsa.models.conversation.ConversationAdditionalAttributes;
import com.agent.tsa.utils.StatusUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConversationEvent
implements Serializable {
    private static final long serialVersionUID = -5255539909370240182L;
    @JsonProperty(value="can_reply")
    private boolean canReply;
    @JsonProperty(value="channel")
    private String channel;
    @JsonProperty(value="contact_inbox")
    private ContactInbox contactInbox;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="inbox_id")
    private Long inboxId;
    @JsonProperty(value="meta")
    private Meta meta;
    @JsonProperty(value="assignee")
    private Assignee assignee;
    @JsonProperty(value="hmac_verified")
    private boolean hmacVerified;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="custom_attributes")
    private Map<String, Object> customAttributes;
    @JsonProperty(value="additional_attributes")
    private ConversationAdditionalAttributes additionalAttributes;
    @JsonProperty(value="unread_count")
    private int unreadCount;
    @JsonProperty(value="waiting_since")
    private long waitingSince;
    @JsonProperty(value="agent_last_seen_at")
    private long agentLastSeenAt;
    @JsonProperty(value="contact_last_seen_at")
    private long contactLastSeenAt;
    @JsonProperty(value="last_activity_at")
    private long lastActivityAt;
    @JsonProperty(value="timestamp")
    private long timestamp;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="event")
    private String event;
    @JsonProperty(value="first_reply_created_at")
    private LocalDateTime firstReplyCreatedAt;
    @JsonProperty(value="labels")
    private List<String> labels;
    @JsonProperty(value="changed_attributes")
    private List<Map<String, Map<String, Object>>> changedAttributes;

    public String getLabelsAsString() {
        return this.labels == null || this.labels.isEmpty() ? "" : String.join((CharSequence)",", this.labels);
    }

    public boolean validateConversationTaggedByMetaAndNeedsContinue(String label) {
        if (this.labels == null) {
            return true;
        }
        return this.labels.size() != 1 || this.status.equals(StatusUtil.ST_CONVERSATION_RESOLVED) || !this.labels.contains(label);
    }

    public boolean hasStateChanged() {
        if (this.changedAttributes == null) {
            return false;
        }
        for (Map change : this.changedAttributes) {
            if (!change.containsKey("status")) continue;
            return true;
        }
        return false;
    }

    public boolean isCanReply() {
        return this.canReply;
    }

    public String getChannel() {
        return this.channel;
    }

    public ContactInbox getContactInbox() {
        return this.contactInbox;
    }

    public Long getId() {
        return this.id;
    }

    public Long getInboxId() {
        return this.inboxId;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public Assignee getAssignee() {
        return this.assignee;
    }

    public boolean isHmacVerified() {
        return this.hmacVerified;
    }

    public String getStatus() {
        return this.status;
    }

    public Map<String, Object> getCustomAttributes() {
        return this.customAttributes;
    }

    public ConversationAdditionalAttributes getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    public long getWaitingSince() {
        return this.waitingSince;
    }

    public long getAgentLastSeenAt() {
        return this.agentLastSeenAt;
    }

    public long getContactLastSeenAt() {
        return this.contactLastSeenAt;
    }

    public long getLastActivityAt() {
        return this.lastActivityAt;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public String getEvent() {
        return this.event;
    }

    public LocalDateTime getFirstReplyCreatedAt() {
        return this.firstReplyCreatedAt;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public List<Map<String, Map<String, Object>>> getChangedAttributes() {
        return this.changedAttributes;
    }

    @JsonProperty(value="can_reply")
    public void setCanReply(boolean canReply) {
        this.canReply = canReply;
    }

    @JsonProperty(value="channel")
    public void setChannel(String channel) {
        this.channel = channel;
    }

    @JsonProperty(value="contact_inbox")
    public void setContactInbox(ContactInbox contactInbox) {
        this.contactInbox = contactInbox;
    }

    @JsonProperty(value="id")
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty(value="inbox_id")
    public void setInboxId(Long inboxId) {
        this.inboxId = inboxId;
    }

    @JsonProperty(value="meta")
    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    @JsonProperty(value="assignee")
    public void setAssignee(Assignee assignee) {
        this.assignee = assignee;
    }

    @JsonProperty(value="hmac_verified")
    public void setHmacVerified(boolean hmacVerified) {
        this.hmacVerified = hmacVerified;
    }

    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="custom_attributes")
    public void setCustomAttributes(Map<String, Object> customAttributes) {
        this.customAttributes = customAttributes;
    }

    @JsonProperty(value="additional_attributes")
    public void setAdditionalAttributes(ConversationAdditionalAttributes additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    @JsonProperty(value="unread_count")
    public void setUnreadCount(int unreadCount) {
        this.unreadCount = unreadCount;
    }

    @JsonProperty(value="waiting_since")
    public void setWaitingSince(long waitingSince) {
        this.waitingSince = waitingSince;
    }

    @JsonProperty(value="agent_last_seen_at")
    public void setAgentLastSeenAt(long agentLastSeenAt) {
        this.agentLastSeenAt = agentLastSeenAt;
    }

    @JsonProperty(value="contact_last_seen_at")
    public void setContactLastSeenAt(long contactLastSeenAt) {
        this.contactLastSeenAt = contactLastSeenAt;
    }

    @JsonProperty(value="last_activity_at")
    public void setLastActivityAt(long lastActivityAt) {
        this.lastActivityAt = lastActivityAt;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="event")
    public void setEvent(String event) {
        this.event = event;
    }

    @JsonProperty(value="first_reply_created_at")
    public void setFirstReplyCreatedAt(LocalDateTime firstReplyCreatedAt) {
        this.firstReplyCreatedAt = firstReplyCreatedAt;
    }

    @JsonProperty(value="labels")
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @JsonProperty(value="changed_attributes")
    public void setChangedAttributes(List<Map<String, Map<String, Object>>> changedAttributes) {
        this.changedAttributes = changedAttributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConversationEvent)) {
            return false;
        }
        ConversationEvent other = (ConversationEvent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isCanReply() != other.isCanReply()) {
            return false;
        }
        if (this.isHmacVerified() != other.isHmacVerified()) {
            return false;
        }
        if (this.getUnreadCount() != other.getUnreadCount()) {
            return false;
        }
        if (this.getWaitingSince() != other.getWaitingSince()) {
            return false;
        }
        if (this.getAgentLastSeenAt() != other.getAgentLastSeenAt()) {
            return false;
        }
        if (this.getContactLastSeenAt() != other.getContactLastSeenAt()) {
            return false;
        }
        if (this.getLastActivityAt() != other.getLastActivityAt()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$inboxId = this.getInboxId();
        Long other$inboxId = other.getInboxId();
        if (this$inboxId == null ? other$inboxId != null : !((Object)this$inboxId).equals(other$inboxId)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        ContactInbox this$contactInbox = this.getContactInbox();
        ContactInbox other$contactInbox = other.getContactInbox();
        if (this$contactInbox == null ? other$contactInbox != null : !this$contactInbox.equals(other$contactInbox)) {
            return false;
        }
        Meta this$meta = this.getMeta();
        Meta other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !this$meta.equals(other$meta)) {
            return false;
        }
        Assignee this$assignee = this.getAssignee();
        Assignee other$assignee = other.getAssignee();
        if (this$assignee == null ? other$assignee != null : !this$assignee.equals(other$assignee)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Map this$customAttributes = this.getCustomAttributes();
        Map other$customAttributes = other.getCustomAttributes();
        if (this$customAttributes == null ? other$customAttributes != null : !((Object)this$customAttributes).equals(other$customAttributes)) {
            return false;
        }
        ConversationAdditionalAttributes this$additionalAttributes = this.getAdditionalAttributes();
        ConversationAdditionalAttributes other$additionalAttributes = other.getAdditionalAttributes();
        if (this$additionalAttributes == null ? other$additionalAttributes != null : !this$additionalAttributes.equals(other$additionalAttributes)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        LocalDateTime this$firstReplyCreatedAt = this.getFirstReplyCreatedAt();
        LocalDateTime other$firstReplyCreatedAt = other.getFirstReplyCreatedAt();
        if (this$firstReplyCreatedAt == null ? other$firstReplyCreatedAt != null : !((Object)this$firstReplyCreatedAt).equals(other$firstReplyCreatedAt)) {
            return false;
        }
        List this$labels = this.getLabels();
        List other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        List this$changedAttributes = this.getChangedAttributes();
        List other$changedAttributes = other.getChangedAttributes();
        return !(this$changedAttributes == null ? other$changedAttributes != null : !((Object)this$changedAttributes).equals(other$changedAttributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConversationEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCanReply() ? 79 : 97);
        result = result * 59 + (this.isHmacVerified() ? 79 : 97);
        result = result * 59 + this.getUnreadCount();
        long $waitingSince = this.getWaitingSince();
        result = result * 59 + (int)($waitingSince >>> 32 ^ $waitingSince);
        long $agentLastSeenAt = this.getAgentLastSeenAt();
        result = result * 59 + (int)($agentLastSeenAt >>> 32 ^ $agentLastSeenAt);
        long $contactLastSeenAt = this.getContactLastSeenAt();
        result = result * 59 + (int)($contactLastSeenAt >>> 32 ^ $contactLastSeenAt);
        long $lastActivityAt = this.getLastActivityAt();
        result = result * 59 + (int)($lastActivityAt >>> 32 ^ $lastActivityAt);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $inboxId = this.getInboxId();
        result = result * 59 + ($inboxId == null ? 43 : ((Object)$inboxId).hashCode());
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        ContactInbox $contactInbox = this.getContactInbox();
        result = result * 59 + ($contactInbox == null ? 43 : $contactInbox.hashCode());
        Meta $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : $meta.hashCode());
        Assignee $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : $assignee.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Map $customAttributes = this.getCustomAttributes();
        result = result * 59 + ($customAttributes == null ? 43 : ((Object)$customAttributes).hashCode());
        ConversationAdditionalAttributes $additionalAttributes = this.getAdditionalAttributes();
        result = result * 59 + ($additionalAttributes == null ? 43 : $additionalAttributes.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        LocalDateTime $firstReplyCreatedAt = this.getFirstReplyCreatedAt();
        result = result * 59 + ($firstReplyCreatedAt == null ? 43 : ((Object)$firstReplyCreatedAt).hashCode());
        List $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        List $changedAttributes = this.getChangedAttributes();
        result = result * 59 + ($changedAttributes == null ? 43 : ((Object)$changedAttributes).hashCode());
        return result;
    }

    public String toString() {
        return "ConversationEvent(canReply=" + this.isCanReply() + ", channel=" + this.getChannel() + ", contactInbox=" + this.getContactInbox() + ", id=" + this.getId() + ", inboxId=" + this.getInboxId() + ", meta=" + this.getMeta() + ", assignee=" + this.getAssignee() + ", hmacVerified=" + this.isHmacVerified() + ", status=" + this.getStatus() + ", customAttributes=" + this.getCustomAttributes() + ", additionalAttributes=" + this.getAdditionalAttributes() + ", unreadCount=" + this.getUnreadCount() + ", waitingSince=" + this.getWaitingSince() + ", agentLastSeenAt=" + this.getAgentLastSeenAt() + ", contactLastSeenAt=" + this.getContactLastSeenAt() + ", lastActivityAt=" + this.getLastActivityAt() + ", timestamp=" + this.getTimestamp() + ", createdAt=" + this.getCreatedAt() + ", event=" + this.getEvent() + ", firstReplyCreatedAt=" + this.getFirstReplyCreatedAt() + ", labels=" + this.getLabels() + ", changedAttributes=" + this.getChangedAttributes() + ")";
    }

    public ConversationEvent(boolean canReply, String channel, ContactInbox contactInbox, Long id, Long inboxId, Meta meta, Assignee assignee, boolean hmacVerified, String status, Map<String, Object> customAttributes, ConversationAdditionalAttributes additionalAttributes, int unreadCount, long waitingSince, long agentLastSeenAt, long contactLastSeenAt, long lastActivityAt, long timestamp, long createdAt, String event, LocalDateTime firstReplyCreatedAt, List<String> labels, List<Map<String, Map<String, Object>>> changedAttributes) {
        this.canReply = canReply;
        this.channel = channel;
        this.contactInbox = contactInbox;
        this.id = id;
        this.inboxId = inboxId;
        this.meta = meta;
        this.assignee = assignee;
        this.hmacVerified = hmacVerified;
        this.status = status;
        this.customAttributes = customAttributes;
        this.additionalAttributes = additionalAttributes;
        this.unreadCount = unreadCount;
        this.waitingSince = waitingSince;
        this.agentLastSeenAt = agentLastSeenAt;
        this.contactLastSeenAt = contactLastSeenAt;
        this.lastActivityAt = lastActivityAt;
        this.timestamp = timestamp;
        this.createdAt = createdAt;
        this.event = event;
        this.firstReplyCreatedAt = firstReplyCreatedAt;
        this.labels = labels;
        this.changedAttributes = changedAttributes;
    }

    public ConversationEvent() {
    }
}

