/*
 * Decompiled with CFR 0.152.
 */
package com.agent.strategy.messagestsa.implement;

import com.agent.client.tsa.message.service.TsaMessageService;
import com.agent.strategy.messagestsa.MessageTsaStrategy;
import com.agent.tsa.DTO.MessageRequestDTO;
import com.agent.tsa.data.conversation.messages.CallbackTsaMessage;
import com.agent.tsa.service.FileService;
import com.agent.tsa.utils.TemplateMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class FileMessageStrategy
implements MessageTsaStrategy {
    private static final Logger log = LoggerFactory.getLogger(FileMessageStrategy.class);
    private final TsaMessageService messageSenderService;
    private final FileService fileService;
    private final Environment env;

    public FileMessageStrategy(TsaMessageService messageSenderService, FileService fileService, Environment env) {
        this.messageSenderService = messageSenderService;
        this.fileService = fileService;
        this.env = env;
    }

    public String getType() {
        return "file";
    }

    public Mono<CallbackTsaMessage> handle(MessageRequestDTO request) {
        String caption = request.getRepliedMessageContent() != null ? TemplateMessage.messageBuilded((String)request.getRepliedMessageContent(), (String)"") : null;
        String token = this.getTokenBySourceMessage(request.getSourceIdentifier());
        return this.fileService.downloadFilesFromMeta(request.getContent(), "", token).flatMap(fileDownloadMeta -> this.messageSenderService.sendMultipartMessageToTSA(fileDownloadMeta, String.valueOf(request.getConversationId()), caption, request.getAccountId()));
    }

    private String getTokenBySourceMessage(String source) {
        if (source == null || source.isEmpty()) {
            log.warn("SOURCE IS NULL OR EMPTY, USING DEFAULT TOKEN");
            return null;
        }
        switch (source.toLowerCase()) {
            case "marci-whatsapp": {
                return this.env.getProperty("marci.whatsapp.token");
            }
            case "mtpwr-whatsapp": {
                return this.env.getProperty("whatsapp.token");
            }
            case "tws-whatsapp": {
                return this.env.getProperty("tws.pruebas.whatsapp.token");
            }
        }
        return this.env.getProperty(source);
    }
}

