/*
 * Decompiled with CFR 0.152.
 */
package com.agent.controller;

import com.agent.tsa.DTO.ConversationsCountDTO;
import com.agent.tsa.DTO.ObservationCountDTO;
import com.agent.tsa.DTO.RequestReportCountConversationsDTO;
import com.agent.tsa.DTO.RequestReportTimeResponseDTO;
import com.agent.tsa.models.Schedules.ScheduleModel;
import com.agent.tsa.service.ReportService;
import com.agent.tsa.service.ScheduleService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"api/ms/reports"})
public class ReportsController {
    private static final Logger log = LoggerFactory.getLogger(ReportsController.class);
    private final ReportService reportService;
    private final ScheduleService scheduleService;

    @PostMapping(value={"/daily-conversations/{empresa}"})
    public Mono<List<ConversationsCountDTO>> getConversationsCount(@PathVariable String empresa, @RequestBody RequestReportCountConversationsDTO body) {
        return this.reportService.getConversationsCount(empresa, body.getInitDate(), body.getEndDate());
    }

    @PostMapping(value={"daily-conversations-labels/{empresa}"})
    public Flux<?> getConversationsLabelsReport(@PathVariable String empresa, @RequestBody RequestReportCountConversationsDTO body) {
        return this.reportService.getConversationLabelsCountByDateAndAccountId(empresa, body.getInitDate(), body.getEndDate());
    }

    @PostMapping(value={"/interactions-count"})
    public Mono<Integer> getInteractionsCount(@RequestBody RequestReportCountConversationsDTO body) {
        return this.reportService.obtenerTokensReactive(body.getInitDate(), body.getEndDate());
    }

    @PostMapping(value={"/personas-count"})
    public Mono<Integer> getPersonasAtendidasCount(@RequestBody RequestReportCountConversationsDTO body) {
        return this.reportService.obtenerPersonasAtendidas(body.getInitDate(), body.getEndDate());
    }

    @PostMapping(value={"/observation-count"})
    public Flux<ObservationCountDTO> getObservationCounts(@RequestBody RequestReportCountConversationsDTO body) {
        return this.reportService.getConversationObservationByDateRange(body.getInitDate(), body.getEndDate());
    }

    @PostMapping(value={"/time-response/{account_id}"})
    public ResponseEntity<Mono<List<ScheduleModel>>> getDataTimeResponse(@RequestBody RequestReportTimeResponseDTO body, @PathVariable String account_id) {
        log.info("\ud83d\udce5 [ReportsController] Recibiendo request /time-response: initDate={}, endDate={}", (Object)body.getInitDate(), (Object)body.getEndDate());
        Mono flux = this.scheduleService.getScheduleByDate(body.getInitDate(), body.getEndDate(), account_id).doOnSubscribe(sub -> log.info("\u27a1\ufe0f [ReportsController] Consultando horarios en BD...")).doOnNext(schedule -> log.debug("\ud83d\udd0e [ReportsController] Registro recibido: {}", schedule)).doOnError(e -> log.error("\u274c [ReportsController] Error obteniendo schedules", e));
        return ResponseEntity.ok((Object)flux);
    }

    public ReportsController(ReportService reportService, ScheduleService scheduleService) {
        this.reportService = reportService;
        this.scheduleService = scheduleService;
    }
}

