/*
 * Decompiled with CFR 0.152.
 */
package com.agent.controller;

import com.agent.tsa.data.RequestMessageModel;
import com.agent.tsa.events.ResponseMessageEvent;
import com.agent.tsa.service.ConversationService;
import com.agent.tsa.service.MessageService;
import jakarta.validation.Valid;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api/ms"})
public class ConversationController {
    private static final Logger log = LoggerFactory.getLogger(ConversationController.class);
    private final MessageService messageService;
    private final ConversationService conversationService;

    @PostMapping(value={"/sendMessage/{callbackid}"})
    public Mono<ResponseEntity<String>> callbackSendMessageTSAGeneralClients(@PathVariable String callbackid, @RequestBody @Valid RequestMessageModel request) {
        log.info("WEBHOOK MESSAGES {} {}", (Object)callbackid, (Object)request);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "ok");
        return this.messageService.processRequestToSendMessage(request, callbackid, null).then(Mono.just((Object)ResponseEntity.ok((Object)((Object)response).toString())));
    }

    @PostMapping(value={"/webhook/tsa/sendMessage/{callbackid}/source/{source}"})
    public Mono<ResponseEntity<ResponseMessageEvent>> callbackSendMessageTSA(@PathVariable String callbackid, @PathVariable String source, @RequestBody @Valid RequestMessageModel request) {
        log.info("WEBHOOK MESSAGES API KEY {} {}", (Object)callbackid, (Object)request);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "ok");
        return this.messageService.processRequestToSendMessage(request, callbackid, source).flatMap(responseEvent -> {
            log.info("Response Event: {}", responseEvent);
            return Mono.just((Object)ResponseEntity.ok((Object)responseEvent));
        });
    }

    @PutMapping(value={"closeConversation/{identifier}/account/{accountId}/close"})
    public Mono<ResponseEntity<String>> closeConversation(@PathVariable String identifier, @PathVariable String accountId) {
        log.info("CERRANDO CONVERSACION {} {}", (Object)identifier, (Object)accountId);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "ok");
        return this.conversationService.closeConversation(identifier, accountId).flatMap(result -> {
            response.put("result", (String)result);
            return Mono.just((Object)ResponseEntity.ok((Object)response.toString()));
        }).onErrorResume(e -> {
            log.error("Error closing conversation: {}", (Object)e.getMessage());
            response.put("error", e.getMessage());
            return Mono.just((Object)ResponseEntity.status((int)400).body((Object)response.toString()));
        });
    }

    public ConversationController(MessageService messageService, ConversationService conversationService) {
        this.messageService = messageService;
        this.conversationService = conversationService;
    }
}

