/*
 * Decompiled with CFR 0.152.
 */
package com.agent.client.tsa.schedule;

import com.agent.client.tsa.schedule.TSAScheduleService;
import com.agent.client.tsa.schedule.models.TSAScheduleModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class TSAScheduleServiceImpl
implements TSAScheduleService {
    private static final Logger log = LoggerFactory.getLogger(TSAScheduleServiceImpl.class);
    private final WebClient webClient;
    private final Environment env;

    public TSAScheduleServiceImpl(@Qualifier(value="whatsappWebClient") WebClient webClient, Environment env, ObjectMapper objectMapper) {
        this.webClient = webClient;
        this.env = env;
    }

    public Mono<Void> saveSchedule(TSAScheduleModel tsaScheduleModel) {
        log.info("[TSA-Service] Iniciando llamada a API para obtener agentes. Account ID: {}, Inbox ID: {}", (Object)tsaScheduleModel.getAccount_id(), (Object)tsaScheduleModel.getInbox_id());
        String urlTemplate = this.env.getProperty("tsa.api.schedule.update");
        String finalUrl = urlTemplate.replace("{account_id}", tsaScheduleModel.getAccount_id()).replace("{inbox_id}", tsaScheduleModel.getInbox_id());
        log.info("[TSA-Service] URL construida para la API: {}", (Object)finalUrl);
        long startTime = System.currentTimeMillis();
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.patch().uri(finalUrl, new Object[0])).header("api_access_token", new String[]{this.env.getProperty("tsa.api.token")})).bodyValue((Object)tsaScheduleModel).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doOnSuccess(response -> {
            long duration = System.currentTimeMillis() - startTime;
            log.info("[TSA-Service] Llamada a API exitosa. Tiempo: {} ms. Respuesta: {}", (Object)duration, response);
        }).doOnError(error -> {
            long duration = System.currentTimeMillis() - startTime;
            log.error("[TSA-Service] Error en llamada a API despu\u00e9s de {} ms. Error: {}", new Object[]{duration, error.getMessage(), error});
        }).onErrorResume(error -> Mono.empty()).then();
    }

    public Mono<Object> getSchedule(String inbox, String account) {
        log.info("[TSA-Service] Iniciando llamada a API para obtener agentes. Account ID: {}, Inbox ID: {}", (Object)account, (Object)inbox);
        String urlTemplate = this.env.getProperty("tsa.api.schedule.update");
        String finalUrl = urlTemplate.replace("{account_id}", account).replace("{inbox_id}", inbox);
        log.info("[TSA-Service] URL construida para la API: {}", (Object)finalUrl);
        long startTime = System.currentTimeMillis();
        return this.webClient.get().uri(finalUrl, new Object[0]).header("api_access_token", new String[]{this.env.getProperty("tsa.api.token")}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doOnSuccess(response -> {
            long duration = System.currentTimeMillis() - startTime;
            log.info("[TSA-Service] Llamada a API exitosa. Tiempo: {} ms. Respuesta: {}", (Object)duration, response);
        }).doOnError(error -> {
            long duration = System.currentTimeMillis() - startTime;
            log.error("[TSA-Service] Error en llamada a API despu\u00e9s de {} ms. Error: {}", new Object[]{duration, error.getMessage(), error});
        }).onErrorResume(error -> Mono.empty());
    }

    public Mono<Object> getAgentAllByInbox(String inbox, String account) {
        log.info("[TSA-Service] Iniciando llamada a API para obtener agentes. Account ID: {}, Inbox ID: {}", (Object)account, (Object)inbox);
        String urlTemplate = this.env.getProperty("tsa.api.agent.all.by.inbox");
        String finalUrl = urlTemplate.replace("{account_id}", account).replace("{inbox_id}", inbox);
        log.info("[TSA-Service] URL construida para la API: {}", (Object)finalUrl);
        long startTime = System.currentTimeMillis();
        return this.webClient.get().uri(finalUrl, new Object[0]).header("api_access_token", new String[]{this.env.getProperty("tsa.api.token")}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doOnSuccess(response -> {
            long duration = System.currentTimeMillis() - startTime;
            log.info("[TSA-Service] Llamada a API exitosa. Tiempo: {} ms. Respuesta: {}", (Object)duration, response);
        }).doOnError(error -> {
            long duration = System.currentTimeMillis() - startTime;
            log.error("[TSA-Service] Error en llamada a API despu\u00e9s de {} ms. Error: {}", new Object[]{duration, error.getMessage(), error});
        }).onErrorResume(error -> Mono.empty());
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    public Environment getEnv() {
        return this.env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TSAScheduleServiceImpl)) {
            return false;
        }
        TSAScheduleServiceImpl other = (TSAScheduleServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        WebClient this$webClient = this.getWebClient();
        WebClient other$webClient = other.getWebClient();
        if (this$webClient == null ? other$webClient != null : !this$webClient.equals(other$webClient)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TSAScheduleServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebClient $webClient = this.getWebClient();
        result = result * 59 + ($webClient == null ? 43 : $webClient.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    public String toString() {
        return "TSAScheduleServiceImpl(webClient=" + this.getWebClient() + ", env=" + this.getEnv() + ")";
    }
}

