/*
 * Decompiled with CFR 0.152.
 */
package com.agent.client.tsa.agent;

import com.agent.client.tsa.agent.AgentRestClientService;
import com.agent.client.tsa.agent.models.AgentModel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class AgentRestClientServiceImpl
implements AgentRestClientService {
    private static final Logger log = LoggerFactory.getLogger(AgentRestClientServiceImpl.class);
    private final WebClient webClient;
    private final Environment env;

    public AgentRestClientServiceImpl(@Qualifier(value="whatsappWebClient") WebClient webClient, Environment env) {
        this.webClient = webClient;
        this.env = env;
    }

    public Mono<List<AgentModel>> getListAgents(String accountId) {
        log.info("MAKING CALL TO GET LIST AGENTS");
        String urlTemplateFindById = this.env.getProperty("tsa.api.agents.list").replace("{account_id}", accountId);
        return this.webClient.get().uri(urlTemplateFindById, new Object[0]).header("api_access_token", new String[]{this.env.getProperty("tsa.api.token")}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doOnSuccess(response -> log.info("API call made successfully with response: {}", response)).onErrorResume(error -> {
            log.error("Error making API call", error);
            return Mono.empty();
        });
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    public Environment getEnv() {
        return this.env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentRestClientServiceImpl)) {
            return false;
        }
        AgentRestClientServiceImpl other = (AgentRestClientServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        WebClient this$webClient = this.getWebClient();
        WebClient other$webClient = other.getWebClient();
        if (this$webClient == null ? other$webClient != null : !this$webClient.equals(other$webClient)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgentRestClientServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebClient $webClient = this.getWebClient();
        result = result * 59 + ($webClient == null ? 43 : $webClient.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    public String toString() {
        return "AgentRestClientServiceImpl(webClient=" + this.getWebClient() + ", env=" + this.getEnv() + ")";
    }
}

