/*
 * Decompiled with CFR 0.152.
 */
package com.agent.cache;

import com.agent.utils.RedisUtils;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ContactCacheService {
    private static final Logger log = LoggerFactory.getLogger(ContactCacheService.class);
    private final ReactiveRedisTemplate<String, String> redisTemplate;
    private static final String REDIS_KEY_TSA = "idTsaByIdentifier:ids";
    private static final String REDIS_KEY_CONTACT = "idContactByIdTsa:ids";

    public Mono<String> getIdTsaByIdentifier(String identifier, String accountId) {
        String redisKey = accountId + ":" + identifier;
        return this.redisTemplate.opsForHash().get((Object)REDIS_KEY_TSA, (Object)redisKey).map(Object::toString);
    }

    public Mono<Boolean> setIdTsaByIdentifier(String identifier, String accountId, Long idTsa) {
        String redisKey = accountId + ":" + identifier;
        return this.redisTemplate.opsForHash().put((Object)REDIS_KEY_TSA, (Object)redisKey, (Object)idTsa.toString()).then(RedisUtils.ApplyTTLifmissing((ReactiveRedisTemplate)this.redisTemplate, (String)REDIS_KEY_TSA, (Duration)Duration.ofHours(24L)));
    }

    public Mono<String> getIdContactByIdTsa(Long idTsa, String accountId) {
        String redisKey = accountId + ":" + idTsa;
        return this.redisTemplate.opsForHash().get((Object)REDIS_KEY_CONTACT, (Object)redisKey).map(Object::toString);
    }

    public Mono<Boolean> setIdContactByIdTsa(Long idTsa, String accountId, Long idContact) {
        String redisKey = accountId + ":" + idTsa;
        return this.redisTemplate.opsForHash().put((Object)REDIS_KEY_CONTACT, (Object)redisKey, (Object)idContact.toString()).then(RedisUtils.ApplyTTLifmissing((ReactiveRedisTemplate)this.redisTemplate, (String)REDIS_KEY_CONTACT, (Duration)Duration.ofHours(24L)));
    }

    public ContactCacheService(ReactiveRedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

