/*
 * Decompiled with CFR 0.152.
 */
package com.agent.auto;

import com.agent.tsa.entity.TConversation;
import com.agent.tsa.repository.ConversationDAO;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class RedissonConversationLockService {
    private static final Logger log = LoggerFactory.getLogger(RedissonConversationLockService.class);
    private final RedissonClient redissonClient;
    private final ConversationDAO conversationDAO;

    public Mono<TConversation> processEventWithLock(TConversation conversation, List<String> labels) {
        Long conversationId = conversation.getConversationId();
        String accountId = conversation.getAccountId();
        log.info("[START] Intentando procesar evento con lock para conversaci\u00f3n {}", (Object)conversationId);
        String lockKey = "lock:conversation:" + conversationId + "|" + accountId;
        RLock lock = this.redissonClient.getLock(lockKey);
        return Mono.fromCallable(() -> {
            log.debug("[LOCK-TRY] Intentando adquirir lock para conversaci\u00f3n {}", (Object)conversationId);
            boolean acquired = lock.tryLock(5L, 10L, TimeUnit.SECONDS);
            if (!acquired) {
                log.warn("[LOCK-FAIL] No se pudo adquirir lock para conversaci\u00f3n {}", (Object)conversationId);
                throw new IllegalStateException("No se pudo bloquear conversaci\u00f3n " + conversationId);
            }
            log.info("[LOCK-ACQUIRED] Lock adquirido para conversaci\u00f3n {}", (Object)conversationId);
            return true;
        }).subscribeOn(Schedulers.boundedElastic()).flatMap(ok -> {
            log.debug("[UPSERT] Ejecutando upsert para conversaci\u00f3n {}", (Object)conversationId);
            return this.processEvent(conversation, labels).doOnSuccess(c -> log.info("[UPSERT-SUCCESS] Upsert exitoso para conversaci\u00f3n {}", (Object)conversationId)).doOnError(e -> log.error("[UPSERT-ERROR] Error durante upsert para conversaci\u00f3n {}: {}", (Object)conversationId, (Object)e.getMessage()));
        }).doFinally(signal -> {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
                log.info("[LOCK-RELEASED] Lock liberado para conversaci\u00f3n {}", (Object)conversationId);
            } else {
                log.debug("[LOCK-SKIP] Lock no estaba retenido por el hilo actual para conversaci\u00f3n {}", (Object)conversationId);
            }
            log.info("[END] Proceso finalizado (se\u00f1al: {}) para conversaci\u00f3n {}", signal, (Object)conversationId);
        });
    }

    private Mono<TConversation> processEvent(TConversation conversation, List<String> labels) {
        String[] array = labels.toArray(new String[0]);
        return this.conversationDAO.upsert(conversation.getConversationId(), conversation.getAgentId(), conversation.getInboxId(), conversation.getTeamId(), conversation.getContactId(), conversation.getAccountId(), conversation.getStatus(), conversation.getCallbackUrl(), conversation.getCreatedAt(), conversation.getUpdatedAt(), conversation.getFirstReplyCreatedAt()).then(this.conversationDAO.syncLabels(conversation.getConversationId(), conversation.getAccountId(), array)).flatMap(response -> {
            log.info("response sync labels conversation {} {}", (Object)conversation.getConversationId(), (Object)conversation.getAccountId());
            return Mono.just((Object)conversation);
        }).thenReturn((Object)conversation);
    }

    public RedissonConversationLockService(RedissonClient redissonClient, ConversationDAO conversationDAO) {
        this.redissonClient = redissonClient;
        this.conversationDAO = conversationDAO;
    }
}

