/*
 * Decompiled with CFR 0.152.
 */
package com.agent.auto;

import com.agent.client.external.service.SendMessagesToApiService;
import com.agent.client.tsa.conversation.service.TsaConversationApiService.TsaConversationApiService;
import com.agent.client.tsa.message.service.TsaMessageService;
import com.agent.tsa.models.conversation.TextMessage;
import com.agent.tsa.service.ConversationService;
import com.agent.tsa.utils.StatusUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class AutoConversationService {
    private static final Logger log = LoggerFactory.getLogger(AutoConversationService.class);
    private final ConversationService conversationService;
    private final SendMessagesToApiService sendMessagesToApiService;
    private final TsaConversationApiService tsaConversationApiService;
    private final TsaMessageService tsaMessageService;
    private final Environment env;

    public Mono<Void> etiquetarConversacionesNoAtendidas() {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(this.env.getProperty("label.caducado"));
        return this.conversationService.findAllConversationsNotClosedToSetTagsOnTsa().flatMap(conversation -> {
            log.info("ETIQUETANDO CONVERSACION {}", (Object)conversation.getConversationId());
            TextMessage textMessage = new TextMessage();
            textMessage.setContent(StatusUtil.MSG_CONVERSACION_CADUCADA);
            textMessage.setPrivate(true);
            textMessage.setContentType("text");
            textMessage.setMessageType("outgoing");
            return this.tsaConversationApiService.addLabelsToConversation(conversation.getConversationId(), labels, conversation.getAccountId()).then(this.tsaMessageService.sendMesssageToTSA(textMessage, String.valueOf(conversation.getConversationId()), conversation.getAccountId())).then(this.conversationService.updateConversationNotifiedTags(conversation.getId()));
        }).then();
    }

    public Mono<Void> resolverConversacionesAntiguas() {
        String daysStr = this.env.getProperty("conversation.auto.resolve.days");
        if (daysStr == null || daysStr.isBlank()) {
            log.info("AUTO-RESOLVE NOT CONFIGURED, SKIPPING OLD CONVERSATIONS RESOLUTION");
            return Mono.empty();
        }
        try {
            int days = Integer.parseInt(daysStr);
            LocalDateTime cutoffDate = LocalDateTime.now().minusDays(days);
            return this.conversationService.findAllConversationsUnrepliedToResolve(cutoffDate).flatMap(conversation -> {
                log.info("CERRANDO CONVERSACION ANTIGUA {}", (Object)conversation.getConversationId());
                return this.tsaConversationApiService.toggleStatusConversation(conversation.getConversationId(), StatusUtil.ST_CONVERSATION_RESOLVED, conversation.getAccountId()).then(this.conversationService.updateConversationStatus(conversation.getConversationId(), StatusUtil.ST_CONVERSATION_RESOLVED, conversation.getAccountId())).then();
            }).then();
        }
        catch (NumberFormatException e) {
            log.error("INVALID AUTO-RESOLVE CONFIGURATION: {}", (Object)daysStr);
            return Mono.empty();
        }
    }

    public Mono<Void> closeAndNotifyAll() {
        return this.conversationService.findAllConversationsToClose().flatMap(conversation -> this.conversationService.updateConversationStatus(conversation.getConversationId(), StatusUtil.ST_CONVERSATION_RESOLVED, conversation.getAccountId()).then(this.closeAndNotify(conversation.getConversationId(), conversation.getAccountId()))).then();
    }

    public Mono<Void> closeAndNotify(Long conversationId, String accountId) {
        log.info("Closing conversation: {}, accountId {}", (Object)conversationId, (Object)accountId);
        return this.conversationService.findIdentifierByidConversationAndAccountId(conversationId, accountId).flatMap(identifier -> this.sendMessagesToApiService.closeConversation(identifier, accountId).defaultIfEmpty((Object)ResponseEntity.ok((Object)"OK")).flatMap(response -> {
            log.info("Conversation close on integration response {}", response);
            if (response.getStatusCode().is2xxSuccessful()) {
                return this.tsaConversationApiService.toggleStatusConversation(conversationId, StatusUtil.ST_CONVERSATION_RESOLVED, accountId).then();
            }
            log.error("Error closing conversation: {}", (Object)conversationId);
            return Mono.empty();
        }));
    }

    public AutoConversationService(ConversationService conversationService, SendMessagesToApiService sendMessagesToApiService, TsaConversationApiService tsaConversationApiService, TsaMessageService tsaMessageService, Environment env) {
        this.conversationService = conversationService;
        this.sendMessagesToApiService = sendMessagesToApiService;
        this.tsaConversationApiService = tsaConversationApiService;
        this.tsaMessageService = tsaMessageService;
        this.env = env;
    }
}

