/*
 * Decompiled with CFR 0.152.
 */
package com.agent.auto;

import com.agent.auto.AutoConversationService;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class AutoCloseScheduler {
    private static final Logger log = LoggerFactory.getLogger(AutoCloseScheduler.class);
    private final AutoConversationService autoConversationService;

    @Scheduled(fixedDelay=60000L)
    @SchedulerLock(name="autoCloseConversationsLock", lockAtLeastFor="1m", lockAtMostFor="2m")
    public void scheduleAutoClose2() {
        long start = System.currentTimeMillis();
        log.info("\ud83d\udd04 Iniciando tareas paralelas de cierre autom\u00e1tico");
        Mono actividadA = this.autoConversationService.closeAndNotifyAll().doOnError(e -> log.error("Error en tarea A: {}", (Object)e.getMessage())).doOnTerminate(() -> log.info("\ud83d\udd04 Tarea A completada"));
        Mono actividadB = this.autoConversationService.etiquetarConversacionesNoAtendidas().doOnError(e -> log.error("Error en tarea B: {}", (Object)e.getMessage())).doOnTerminate(() -> log.info("\ud83d\udd04 Tarea B completada"));
        Mono actividadC = this.autoConversationService.resolverConversacionesAntiguas().doOnError(e -> log.error("Error en tarea C: {}", (Object)e.getMessage())).doOnTerminate(() -> log.info("\ud83d\udd04 Tarea C completada"));
        Mono.when((Publisher[])new Publisher[]{actividadA, actividadB, actividadC}).doOnSuccess(aVoid -> {
            long duration = System.currentTimeMillis() - start;
            log.info("\u2705 Ambas tareas completadas en {} ms", (Object)duration);
        }).doOnError(e -> log.error("Error ejecutando las tareas: {}", (Object)e.getMessage())).subscribe();
    }

    public AutoCloseScheduler(AutoConversationService autoConversationService) {
        this.autoConversationService = autoConversationService;
    }
}

