/*
 * Decompiled with CFR 0.152.
 */
package com.agent;

import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@SpringBootApplication
@EnableDiscoveryClient
public class LhiaAgentServiceApplication
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(LhiaAgentServiceApplication.class);
    private final Environment env;

    public LhiaAgentServiceApplication(Environment environment) {
        this.env = environment;
    }

    public static void main(String[] args) {
        TimeZone.setDefault(TimeZone.getTimeZone("America/Guayaquil"));
        SpringApplication.run(LhiaAgentServiceApplication.class, (String[])args);
    }

    public void run(String ... args) throws Exception {
        log.info("Starting LhiaAgentServiceApplication...");
        log.info("started successfully!");
        log.info("running in {} mode", (Object)this.env.getProperty("spring.profiles.active"));
        log.info("running on port {} with context path {}", (Object)this.env.getProperty("server.port"), (Object)this.env.getProperty("server.servlet.context-path"));
        log.info("running with host {}", (Object)this.env.getProperty("spring.cloud.gateway.routes.lhia-agent-service.uri"));
    }
}

