/*
 * Decompiled with CFR 0.152.
 */
package com.meta.tws2.utils;

import com.meta.tws2.DTO.DailyCountDTO;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Utils {
    public static String truncateString(String input, int limit) {
        if (input != null && input.length() > limit) {
            return input.substring(0, limit);
        }
        return input;
    }

    public static String cleanString(String input) {
        if (input == null) {
            return "";
        }
        return input.replaceAll("[\\t\\n\\r]", " ").replaceAll("\\s{2,}", " ").trim();
    }

    public static List<DailyCountDTO> completarDiasFaltantes(List<DailyCountDTO> resultados, LocalDate inicio, LocalDate fin) {
        Map<String, Long> map = resultados.stream().collect(Collectors.toMap(DailyCountDTO::getDate, DailyCountDTO::getTotal));
        ArrayList<DailyCountDTO> resultadoCompleto = new ArrayList<DailyCountDTO>();
        LocalDate actual = inicio;
        while (!actual.isAfter(fin)) {
            String fechaStr = actual.toString();
            long total = map.getOrDefault(fechaStr, 0L);
            resultadoCompleto.add(new DailyCountDTO(fechaStr, total));
            actual = actual.plusDays(1L);
        }
        return resultadoCompleto;
    }
}

