/*
 * Decompiled with CFR 0.152.
 */
package com.meta.tws2.utils;

import com.meta.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.meta.tws2.data.ExtractData;
import com.meta.tws2.data.UserResponse;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ResponseUtil {
    private final ApiWhatsAppService apiWhatsAppService;

    public Mono<ExtractData> getMessage(UserResponse userResponse) {
        String object = userResponse.getObject();
        if (object == null) {
            return Mono.empty();
        }
        if (object.equals("whatsapp_business_account")) {
            List entry = userResponse.getEntry();
            for (UserResponse.Entry value : entry) {
                List changes = value.getChanges();
                for (UserResponse.Change change : changes) {
                    String nickname;
                    UserResponse.Value valueChange = change.getValue();
                    String messageProduct = valueChange.getMessaging_product();
                    if (!messageProduct.equals("whatsapp")) continue;
                    List messages = valueChange.getMessages();
                    List contacts = valueChange.getContacts();
                    if (messages == null) {
                        return Mono.empty();
                    }
                    String string = nickname = contacts != null ? ((UserResponse.Contact)contacts.get(0)).getProfile().getName() : null;
                    Iterator iterator = messages.iterator();
                    if (!iterator.hasNext()) continue;
                    UserResponse.Message message = (UserResponse.Message)iterator.next();
                    String canal = messageProduct;
                    String from = message.getFrom();
                    String type = message.getType();
                    String messageId = message.getId();
                    UserResponse.Context context = message.getContext();
                    String messageReplyId = context == null ? null : context.getId();
                    switch (type) {
                        case "text": {
                            String msg = message.getText().getBody();
                            return Mono.just((Object)new ExtractData(from, canal, nickname, type, msg, messageId, messageReplyId, null, null, null, null));
                        }
                        case "image": {
                            return this.apiWhatsAppService.downloadMediaFile(message.getImage().getId()).map(file -> new ExtractData(from, canal, nickname, type, null, messageId, messageReplyId, file.getUrl(), null, null, null));
                        }
                        case "sticker": {
                            return this.apiWhatsAppService.downloadMediaFile(message.getSticker().getId()).map(file -> new ExtractData(from, canal, nickname, type, null, messageId, messageReplyId, file.getUrl(), null, null, null));
                        }
                        case "audio": {
                            return this.apiWhatsAppService.downloadMediaFile(message.getAudio().getId()).map(file -> new ExtractData(from, canal, nickname, type, null, messageId, messageReplyId, file.getUrl(), null, null, null));
                        }
                        case "video": {
                            return this.apiWhatsAppService.downloadMediaFile(message.getVideo().getId()).map(file -> new ExtractData(from, canal, nickname, type, null, messageId, messageReplyId, file.getUrl(), null, null, null));
                        }
                        case "document": {
                            String fileName = message.getDocument().getFilename();
                            String fileNameCompletion = UUID.randomUUID().toString().concat(fileName);
                            return this.apiWhatsAppService.downloadMediaFile(message.getDocument().getId()).map(file -> new ExtractData(from, canal, nickname, type, null, messageId, messageReplyId, file.getUrl(), fileNameCompletion, null, null));
                        }
                        case "location": {
                            String lon = message.getLocation().getLongitude();
                            String lat = message.getLocation().getLatitude();
                            return Mono.just((Object)new ExtractData(from, canal, nickname, type, lat, lon, messageReplyId));
                        }
                        case "interactive": {
                            UserResponse.Interactive interactive = message.getInteractive();
                            String msg = "";
                            String buttonId = null;
                            String buttonTitle = null;
                            if (interactive.getType().equals("button_reply")) {
                                UserResponse.ButtonReply buttonReply = interactive.getButton_reply();
                                msg = buttonReply.getTitle();
                                buttonTitle = buttonReply.getTitle();
                                buttonId = buttonReply.getId();
                            }
                            return Mono.just((Object)new ExtractData(from, canal, nickname, type, msg, messageId, messageReplyId, null, null, buttonId, buttonTitle));
                        }
                    }
                    return Mono.just((Object)new ExtractData(from, canal, nickname, type, null, messageId, messageReplyId, null, null, null, null));
                }
            }
        }
        return Mono.empty();
    }

    public ResponseUtil(ApiWhatsAppService apiWhatsAppService) {
        this.apiWhatsAppService = apiWhatsAppService;
    }
}

